/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.spi.block.ArrayAllocator;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleArrayAllocator
implements ArrayAllocator {
    private static final int DEFAULT_MAX_OUTSTANDING = 1000;
    private final int maxOutstandingArrays;
    private final Deque<int[]> intArrays = new ArrayDeque<int[]>();
    private final Set<int[]> borrowedIntArrays = Collections.newSetFromMap(new IdentityHashMap());
    private long estimatedSizeInBytes;

    public SimpleArrayAllocator() {
        this(1000);
    }

    public SimpleArrayAllocator(int maxOutstandingArrays) {
        Preconditions.checkArgument((maxOutstandingArrays > 0 ? 1 : 0) != 0, (Object)"maxOutstandingArrays must be positive");
        this.maxOutstandingArrays = maxOutstandingArrays;
    }

    public int[] borrowIntArray(int positionCount) {
        int[] array;
        Preconditions.checkState((this.borrowedIntArrays.size() < this.maxOutstandingArrays ? 1 : 0) != 0, (String)"Requested too many arrays: %s", (int)this.borrowedIntArrays.size());
        while (!this.intArrays.isEmpty() && this.intArrays.peek().length < positionCount) {
            array = this.intArrays.pop();
            this.estimatedSizeInBytes -= SizeOf.sizeOf((int[])array);
        }
        if (this.intArrays.isEmpty()) {
            array = new int[positionCount];
            this.estimatedSizeInBytes += SizeOf.sizeOf((int[])array);
        } else {
            array = this.intArrays.pop();
        }
        Verify.verify((boolean)this.borrowedIntArrays.add(array), (String)"Attempted to borrow array which was already borrowed", (Object[])new Object[0]);
        return array;
    }

    public void returnArray(int[] array) {
        Objects.requireNonNull(array, "array is null");
        Preconditions.checkArgument((boolean)this.borrowedIntArrays.remove(array), (Object)"Returned int array which was not borrowed");
        this.intArrays.push(array);
    }

    public int getBorrowedArrayCount() {
        return this.borrowedIntArrays.size();
    }

    public long getEstimatedSizeInBytes() {
        return this.estimatedSizeInBytes;
    }
}

