/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class RowComparator
implements Comparator<Page> {
    private final List<Type> sortTypes;
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrders;

    public RowComparator(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.sortTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortTypes, "sortTypes is null"));
        this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        Preconditions.checkArgument((sortTypes.size() == sortChannels.size() ? 1 : 0) != 0, (String)"sortTypes size (%s) doesn't match sortChannels size (%s)", (int)sortTypes.size(), (int)sortChannels.size());
        Preconditions.checkArgument((sortChannels.size() == sortOrders.size() ? 1 : 0) != 0, (String)"sortFields size (%s) doesn't match sortOrders size (%s)", (int)sortChannels.size(), (int)sortOrders.size());
    }

    @Override
    public int compare(Page leftRow, Page rightRow) {
        for (int index = 0; index < this.sortChannels.size(); ++index) {
            Block right;
            Block left;
            Type type = this.sortTypes.get(index);
            int channel = this.sortChannels.get(index);
            SortOrder sortOrder = this.sortOrders.get(index);
            int comparison = sortOrder.compareBlockValue(type, left = leftRow.getBlock(channel), 0, right = rightRow.getBlock(channel), 0);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }
}

