/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.openjdk.jol.info.ClassLayout;

public class GroupByIdBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupByIdBlock.class).instanceSize();
    private final long groupCount;
    private final Block block;

    public GroupByIdBlock(long groupCount, Block block) {
        Objects.requireNonNull(block, "block is null");
        this.groupCount = groupCount;
        this.block = block;
    }

    public long getGroupCount() {
        return this.groupCount;
    }

    public long getGroupId(int position) {
        return BigintType.BIGINT.getLong(this.block, position);
    }

    public Block getRegion(int positionOffset, int length) {
        return this.block.getRegion(positionOffset, length);
    }

    public long getRegionSizeInBytes(int positionOffset, int length) {
        return this.block.getRegionSizeInBytes(positionOffset, length);
    }

    public long getPositionsSizeInBytes(boolean[] positions) {
        return this.block.getPositionsSizeInBytes(positions);
    }

    public Block copyRegion(int positionOffset, int length) {
        return this.block.copyRegion(positionOffset, length);
    }

    public int getSliceLength(int position) {
        return this.block.getSliceLength(position);
    }

    public byte getByte(int position) {
        return this.block.getByte(position);
    }

    public short getShort(int position) {
        return this.block.getShort(position);
    }

    public int getInt(int position) {
        return this.block.getInt(position);
    }

    public long getLong(int position) {
        return this.block.getLong(position);
    }

    public long getLong(int position, int offset) {
        return this.block.getLong(position, offset);
    }

    public Slice getSlice(int position, int offset, int length) {
        return this.block.getSlice(position, offset, length);
    }

    public Block getBlock(int position) {
        return this.block.getBlock(position);
    }

    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.block.bytesEqual(position, offset, otherSlice, otherOffset, length);
    }

    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.block.bytesCompare(position, offset, length, otherSlice, otherOffset, otherLength);
    }

    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.block.writeBytesTo(position, offset, length, blockBuilder);
    }

    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.block.writePositionTo(position, blockBuilder);
    }

    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.block.equals(position, offset, otherBlock, otherPosition, otherOffset, length);
    }

    public long hash(int position, int offset, int length) {
        return this.block.hash(position, offset, length);
    }

    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.block.compareTo(leftPosition, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    public Block getSingleValueBlock(int position) {
        return this.block.getSingleValueBlock(position);
    }

    public boolean isNull(int position) {
        return this.block.isNull(position);
    }

    public int getPositionCount() {
        return this.block.getPositionCount();
    }

    public long getSizeInBytes() {
        return this.block.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.block.getRetainedSizeInBytes();
    }

    public long getEstimatedDataSizeForStats(int position) {
        return this.block.getEstimatedDataSizeForStats(position);
    }

    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.block, this.block.getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    public String getEncodingName() {
        throw new UnsupportedOperationException("GroupByIdBlock does not support serialization");
    }

    public Block copyPositions(int[] positions, int offset, int length) {
        return this.block.copyPositions(positions, offset, length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupCount", this.groupCount).add("positionCount", this.getPositionCount()).toString();
    }

    public Block getLoadedBlock() {
        return this.block.getLoadedBlock();
    }

    public byte getByteUnchecked(int internalPosition) {
        return this.block.getByte(internalPosition);
    }

    public short getShortUnchecked(int internalPosition) {
        return this.block.getShort(internalPosition);
    }

    public int getIntUnchecked(int internalPosition) {
        return this.block.getInt(internalPosition);
    }

    public long getLongUnchecked(int internalPosition) {
        return this.block.getLong(internalPosition);
    }

    public long getLongUnchecked(int internalPosition, int offset) {
        return this.block.getLong(internalPosition, offset);
    }

    public Slice getSliceUnchecked(int internalPosition, int offset, int length) {
        return this.block.getSlice(internalPosition, offset, length);
    }

    public int getSliceLengthUnchecked(int internalPosition) {
        return this.block.getSliceLength(internalPosition);
    }

    public Block getBlockUnchecked(int internalPosition) {
        return this.block.getBlock(internalPosition);
    }

    public int getOffsetBase() {
        return 0;
    }

    public boolean isNullUnchecked(int internalPosition) {
        return this.block.isNull(internalPosition);
    }
}

