/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class DeleteOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int rowIdChannel;
    private final JsonCodec<TableCommitContext> tableCommitContextCodec;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean closed;
    private ListenableFuture<Collection<Slice>> finishFuture;
    private Supplier<Optional<UpdatablePageSource>> pageSource = Optional::empty;

    public DeleteOperator(OperatorContext operatorContext, int rowIdChannel, JsonCodec<TableCommitContext> tableCommitContextCodec) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.rowIdChannel = rowIdChannel;
        this.tableCommitContextCodec = Objects.requireNonNull(tableCommitContextCodec, "tableCommitContextCodec is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
            this.finishFuture = MoreFutures.toListenableFuture((CompletableFuture)this.pageSource().finish());
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        Block rowIds = page.getBlock(this.rowIdChannel);
        this.pageSource().deleteRows(rowIds);
        this.rowCount += (long)rowIds.getPositionCount();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.finishFuture == null) {
            return NOT_BLOCKED;
        }
        return this.finishFuture;
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING || !this.finishFuture.isDone()) {
            return null;
        }
        this.state = State.FINISHED;
        Collection fragments = (Collection)MoreFutures.getFutureValue(this.finishFuture);
        int positionCount = fragments.size() + 1;
        BlockBuilder rowsBuilder = BigintType.BIGINT.createBlockBuilder(null, positionCount);
        BlockBuilder fragmentBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, positionCount);
        rowsBuilder.writeLong(this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        TaskId taskId = this.operatorContext.getDriverContext().getPipelineContext().getTaskId();
        Slice tableCommitContext = Slices.wrappedBuffer((byte[])this.tableCommitContextCodec.toJsonBytes((Object)new TableCommitContext(this.operatorContext.getDriverContext().getLifespan(), taskId, false, true)));
        return new Page(positionCount, new Block[]{rowsBuilder.build(), fragmentBuilder.build(), RunLengthEncodedBlock.create((Type)VarbinaryType.VARBINARY, (Object)tableCommitContext, (int)positionCount)});
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.finishFuture != null) {
                this.finishFuture.cancel(true);
            } else {
                this.pageSource.get().ifPresent(UpdatablePageSource::abort);
            }
        }
    }

    public void setPageSource(Supplier<Optional<UpdatablePageSource>> pageSource) {
        this.pageSource = Objects.requireNonNull(pageSource, "pageSource is null");
    }

    private UpdatablePageSource pageSource() {
        Optional<UpdatablePageSource> source = this.pageSource.get();
        Preconditions.checkState((boolean)source.isPresent(), (Object)"UpdatablePageSource not set");
        return source.get();
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class DeleteOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final int rowIdChannel;
        private final JsonCodec<TableCommitContext> tableCommitContextCodec;
        private boolean closed;

        public DeleteOperatorFactory(int operatorId, PlanNodeId planNodeId, int rowIdChannel, JsonCodec<TableCommitContext> tableCommitContextCodec) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.rowIdChannel = rowIdChannel;
            this.tableCommitContextCodec = Objects.requireNonNull(tableCommitContextCodec, "tableCommitContextCodec is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, DeleteOperator.class.getSimpleName());
            return new DeleteOperator(context, this.rowIdChannel, this.tableCommitContextCodec);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new DeleteOperatorFactory(this.operatorId, this.planNodeId, this.rowIdChannel, this.tableCommitContextCodec);
        }
    }
}

