/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunction;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.PolymorphicScalarFunctionBuilder;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import java.util.Objects;

public abstract class SqlScalarFunction
extends BuiltInFunction {
    private final Signature signature;

    protected SqlScalarFunction(Signature signature) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        Preconditions.checkArgument((signature.getKind() == FunctionKind.SCALAR ? 1 : 0) != 0, (Object)"function kind must be SCALAR");
    }

    public final Signature getSignature() {
        return this.signature;
    }

    public abstract ScalarFunctionImplementation specialize(BoundVariables var1, int var2, TypeManager var3, FunctionManager var4);

    public static PolymorphicScalarFunctionBuilder builder(Class<?> clazz, OperatorType operatorType) {
        return new PolymorphicScalarFunctionBuilder(clazz, operatorType);
    }

    public static PolymorphicScalarFunctionBuilder builder(Class<?> clazz) {
        return new PolymorphicScalarFunctionBuilder(clazz);
    }
}

