/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunction;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.aggregation.AggregationFromAnnotationsParser;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public abstract class SqlAggregationFunction
extends BuiltInFunction {
    private final Signature signature;
    private final boolean hidden;

    public static List<SqlAggregationFunction> createFunctionByAnnotations(Class<?> aggregationDefinition) {
        return ImmutableList.of((Object)AggregationFromAnnotationsParser.parseFunctionDefinition(aggregationDefinition));
    }

    public static List<SqlAggregationFunction> createFunctionsByAnnotations(Class<?> aggregationDefinition) {
        return (List)AggregationFromAnnotationsParser.parseFunctionDefinitions(aggregationDefinition).stream().map(x -> x).collect(ImmutableList.toImmutableList());
    }

    protected SqlAggregationFunction(String name, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        this(name, typeVariableConstraints, longVariableConstraints, returnType, argumentTypes, FunctionKind.AGGREGATE);
    }

    protected SqlAggregationFunction(String name, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes, FunctionKind kind) {
        this(SqlAggregationFunction.createSignature(name, typeVariableConstraints, longVariableConstraints, returnType, argumentTypes, kind), false);
    }

    protected SqlAggregationFunction(Signature signature, boolean hidden) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.hidden = hidden;
    }

    private static Signature createSignature(String name, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes, FunctionKind kind) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null");
        Objects.requireNonNull(longVariableConstraints, "longVariableConstraints is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        Preconditions.checkArgument((kind == FunctionKind.AGGREGATE ? 1 : 0) != 0, (Object)"kind must be an aggregate");
        return new Signature(FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)name), kind, (List)ImmutableList.copyOf(typeVariableConstraints), (List)ImmutableList.copyOf(longVariableConstraints), returnType, (List)ImmutableList.copyOf(argumentTypes), false);
    }

    public final Signature getSignature() {
        return this.signature;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDeterministic() {
        return true;
    }

    public abstract InternalAggregationFunction specialize(BoundVariables var1, int var2, TypeManager var3, FunctionManager var4);
}

