/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunction;
import java.util.Objects;

public class SpecializedFunctionKey {
    private final BuiltInFunction function;
    private final BoundVariables boundVariables;
    private final int arity;

    public SpecializedFunctionKey(BuiltInFunction function, BoundVariables boundVariables, int arity) {
        this.function = Objects.requireNonNull(function, "function is null");
        this.boundVariables = Objects.requireNonNull(boundVariables, "boundVariables is null");
        this.arity = arity;
    }

    public BuiltInFunction getFunction() {
        return this.function;
    }

    public BoundVariables getBoundVariables() {
        return this.boundVariables;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecializedFunctionKey that = (SpecializedFunctionKey)o;
        return Objects.equals(this.boundVariables, that.boundVariables) && Objects.equals(this.function.getSignature(), that.function.getSignature()) && this.arity == that.arity;
    }

    public int hashCode() {
        return Objects.hash(this.function.getSignature(), this.boundVariables, this.arity);
    }
}

