/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionInvoker;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.InvocationConvention;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class FunctionInvokerProvider {
    private final FunctionManager functionManager;

    public FunctionInvokerProvider(FunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    public FunctionInvoker createFunctionInvoker(FunctionHandle functionHandle, Optional<InvocationConvention> invocationConvention) {
        ScalarFunctionImplementation scalarFunctionImplementation = this.functionManager.getScalarFunctionImplementation(functionHandle);
        for (ScalarFunctionImplementation.ScalarImplementationChoice choice : scalarFunctionImplementation.getAllChoices()) {
            if (!FunctionInvokerProvider.checkChoice(choice.getArgumentProperties(), choice.isNullable(), choice.hasSession(), invocationConvention)) continue;
            return new FunctionInvoker(choice.getMethodHandle());
        }
        Preconditions.checkState((boolean)invocationConvention.isPresent());
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Dependent function implementation (%s) with convention (%s) is not available", functionHandle, invocationConvention.toString()));
    }

    @VisibleForTesting
    static boolean checkChoice(List<ScalarFunctionImplementation.ArgumentProperty> definitionArgumentProperties, boolean definitionReturnsNullable, boolean definitionHasSession, Optional<InvocationConvention> invocationConvention) {
        for (int i = 0; i < definitionArgumentProperties.size(); ++i) {
            InvocationConvention.InvocationArgumentConvention invocationArgumentConvention = invocationConvention.get().getArgumentConvention(i);
            ScalarFunctionImplementation.NullConvention nullConvention = definitionArgumentProperties.get(i).getNullConvention();
            if (definitionArgumentProperties.get(i).getArgumentType() == ScalarFunctionImplementation.ArgumentType.FUNCTION_TYPE) {
                if (invocationArgumentConvention != InvocationConvention.InvocationArgumentConvention.FUNCTION) {
                    return false;
                }
                throw new UnsupportedOperationException("Invocation convention for function type is not supported");
            }
            if (nullConvention == ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL && invocationArgumentConvention != InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                return false;
            }
            if (nullConvention == ScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE && invocationArgumentConvention != InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
                return false;
            }
            if (nullConvention == ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG && invocationArgumentConvention != InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                return false;
            }
            if (nullConvention != ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION || invocationArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) continue;
            return false;
        }
        if (definitionReturnsNullable && invocationConvention.get().getReturnConvention() != InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN) {
            return false;
        }
        if (!definitionReturnsNullable && invocationConvention.get().getReturnConvention() != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
            return false;
        }
        return definitionHasSession == invocationConvention.get().hasSession();
    }
}

