/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.relation.FullyQualifiedName;

public enum CastType {
    CAST(OperatorType.CAST.getFunctionName(), true),
    SATURATED_FLOOR_CAST(OperatorType.SATURATED_FLOOR_CAST.getFunctionName(), true),
    TRY_CAST(FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"TRY_CAST"), false),
    JSON_TO_ARRAY_CAST(FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$internal$json_string_to_array_cast"), false),
    JSON_TO_MAP_CAST(FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$internal$json_string_to_map_cast"), false),
    JSON_TO_ROW_CAST(FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$internal$json_string_to_row_cast"), false);

    private final FullyQualifiedName castName;
    private final boolean isOperatorType;

    private CastType(FullyQualifiedName castName, boolean isOperatorType) {
        this.castName = castName;
        this.isOperatorType = isOperatorType;
    }

    public FullyQualifiedName getCastName() {
        return this.castName;
    }

    public boolean isOperatorType() {
        return this.isOperatorType;
    }

    public static OperatorType toOperatorType(CastType castType) {
        switch (castType) {
            case CAST: {
                return OperatorType.CAST;
            }
            case SATURATED_FLOOR_CAST: {
                return OperatorType.SATURATED_FLOOR_CAST;
            }
        }
        throw new IllegalArgumentException(String.format("No OperatorType for CastType %s", new Object[]{castType}));
    }
}

