/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.group;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.SourceScheduler;
import com.facebook.presto.execution.scheduler.group.LifespanScheduler;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.SettableFuture;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.concurrent.GuardedBy;

public class DynamicLifespanScheduler
implements LifespanScheduler {
    private static final int NOT_ASSIGNED = -1;
    private final BucketNodeMap bucketNodeMap;
    private final List<InternalNode> nodeByTaskId;
    private final List<ConnectorPartitionHandle> partitionHandles;
    private final OptionalInt concurrentLifespansPerTask;
    private final IntSet[] runningDriverGroupIdsByTask;
    private final int[] taskByDriverGroup;
    private final IntArrayFIFOQueue driverGroupQueue;
    private final IntSet failedTasks;
    private boolean initialScheduled;
    private SettableFuture<?> newDriverGroupReady = SettableFuture.create();
    @GuardedBy(value="this")
    private final IntArrayFIFOQueue availableTasks = new IntArrayFIFOQueue();
    @GuardedBy(value="this")
    private int totalLifespanExecutionFinished;

    public DynamicLifespanScheduler(BucketNodeMap bucketNodeMap, List<InternalNode> nodeByTaskId, List<ConnectorPartitionHandle> partitionHandles, OptionalInt concurrentLifespansPerTask) {
        int i;
        this.bucketNodeMap = Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
        this.nodeByTaskId = Objects.requireNonNull(nodeByTaskId, "nodeByTaskId is null");
        this.partitionHandles = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(partitionHandles, "partitionHandles is null")));
        this.concurrentLifespansPerTask = Objects.requireNonNull(concurrentLifespansPerTask, "concurrentLifespansPerTask is null");
        concurrentLifespansPerTask.ifPresent(lifespansPerTask -> Preconditions.checkArgument((lifespansPerTask >= 1 ? 1 : 0) != 0, (Object)"concurrentLifespansPerTask must be great or equal to 1 if present"));
        int bucketCount = partitionHandles.size();
        Verify.verify((bucketCount > 0 ? 1 : 0) != 0);
        this.runningDriverGroupIdsByTask = new IntSet[nodeByTaskId.size()];
        for (i = 0; i < nodeByTaskId.size(); ++i) {
            this.runningDriverGroupIdsByTask[i] = new IntOpenHashSet();
        }
        this.taskByDriverGroup = new int[bucketCount];
        this.driverGroupQueue = new IntArrayFIFOQueue(bucketCount);
        for (i = 0; i < bucketCount; ++i) {
            this.taskByDriverGroup[i] = -1;
            this.driverGroupQueue.enqueue(i);
        }
        this.failedTasks = new IntOpenHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleInitial(SourceScheduler scheduler) {
        Preconditions.checkState((!this.initialScheduled ? 1 : 0) != 0, (Object)"Initial scheduling happened before scheduleInitial is called");
        int driverGroupsScheduledPerTask = 0;
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            while (!this.driverGroupQueue.isEmpty()) {
                for (int i = 0; i < this.nodeByTaskId.size() && !this.driverGroupQueue.isEmpty(); ++i) {
                    int driverGroupId = this.driverGroupQueue.dequeueInt();
                    Preconditions.checkState((!this.bucketNodeMap.getAssignedNode(driverGroupId).isPresent() ? 1 : 0) != 0);
                    this.bucketNodeMap.assignOrUpdateBucketToNode(driverGroupId, this.nodeByTaskId.get(i));
                    scheduler.startLifespan(Lifespan.driverGroup(driverGroupId), this.partitionHandles.get(driverGroupId));
                    this.taskByDriverGroup[driverGroupId] = i;
                    this.runningDriverGroupIdsByTask[i].add(driverGroupId);
                }
                if (!this.concurrentLifespansPerTask.isPresent() || ++driverGroupsScheduledPerTask != this.concurrentLifespansPerTask.getAsInt()) continue;
            }
            this.initialScheduled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLifespanExecutionFinished(Iterable<Lifespan> newlyCompletelyExecutedDriverGroups) {
        SettableFuture<?> newDriverGroupReady;
        Preconditions.checkState((boolean)this.initialScheduled, (Object)"onLifespanExecutionFinished should only be called after initial scheduling finished");
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            for (Lifespan newlyCompletelyExecutedDriverGroup : newlyCompletelyExecutedDriverGroups) {
                Preconditions.checkArgument((!newlyCompletelyExecutedDriverGroup.isTaskWide() ? 1 : 0) != 0);
                int driverGroupId = newlyCompletelyExecutedDriverGroup.getId();
                this.availableTasks.enqueue(this.taskByDriverGroup[driverGroupId]);
                ++this.totalLifespanExecutionFinished;
                this.runningDriverGroupIdsByTask[this.taskByDriverGroup[driverGroupId]].remove(driverGroupId);
            }
            newDriverGroupReady = this.newDriverGroupReady;
        }
        newDriverGroupReady.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskFailed(int taskId, List<SourceScheduler> sourceSchedulers) {
        Preconditions.checkState((boolean)this.initialScheduled, (Object)"onTaskFailed should only be called after initial scheduling finished");
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            this.failedTasks.add(taskId);
            IntIterator intIterator = this.runningDriverGroupIdsByTask[taskId].iterator();
            while (intIterator.hasNext()) {
                int driverGroupId = (Integer)intIterator.next();
                for (SourceScheduler sourceScheduler : sourceSchedulers) {
                    sourceScheduler.rewindLifespan(Lifespan.driverGroup(driverGroupId), this.partitionHandles.get(driverGroupId));
                }
                this.driverGroupQueue.enqueue(driverGroupId);
            }
            this.runningDriverGroupIdsByTask[taskId].clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettableFuture schedule(SourceScheduler scheduler) {
        Preconditions.checkState((boolean)this.initialScheduled, (Object)"schedule should only be called after initial scheduling finished");
        Preconditions.checkState((this.failedTasks.size() < this.nodeByTaskId.size() ? 1 : 0) != 0, (Object)"All tasks have failed");
        DynamicLifespanScheduler dynamicLifespanScheduler = this;
        synchronized (dynamicLifespanScheduler) {
            this.newDriverGroupReady = SettableFuture.create();
            while (!this.availableTasks.isEmpty() && !this.driverGroupQueue.isEmpty()) {
                int taskId = this.availableTasks.dequeueInt();
                if (this.failedTasks.contains(taskId)) continue;
                int nextDriverGroupId = this.driverGroupQueue.dequeueInt();
                InternalNode nodeForCompletedDriverGroup = this.nodeByTaskId.get(taskId);
                this.bucketNodeMap.assignOrUpdateBucketToNode(nextDriverGroupId, nodeForCompletedDriverGroup);
                scheduler.startLifespan(Lifespan.driverGroup(nextDriverGroupId), this.partitionHandles.get(nextDriverGroupId));
                this.taskByDriverGroup[nextDriverGroupId] = taskId;
                this.runningDriverGroupIdsByTask[taskId].add(nextDriverGroupId);
            }
        }
        return this.newDriverGroupReady;
    }

    @Override
    public synchronized boolean allLifespanExecutionFinished() {
        return this.totalLifespanExecutionFinished == this.partitionHandles.size();
    }
}

