/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.scheduler.NodeScheduler;
import io.airlift.stats.CounterStat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

public final class NodeSchedulerExporter {
    private final MBeanExporter exporter;
    @GuardedBy(value="this")
    private final List<String> objectNames = new ArrayList<String>();

    @Inject
    public NodeSchedulerExporter(NodeScheduler nodeScheduler, MBeanExporter exporter) {
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
        Map<String, CounterStat> topologicalSplitCounters = nodeScheduler.getTopologicalSplitCounters();
        for (Map.Entry<String, CounterStat> entry : topologicalSplitCounters.entrySet()) {
            try {
                String objectName = ObjectNames.builder(NodeScheduler.class).withProperty("segment", entry.getKey()).build();
                this.exporter.export(objectName, (Object)entry.getValue());
                this.objectNames.add(objectName);
            }
            catch (JmxException jmxException) {}
        }
    }

    @PreDestroy
    public synchronized void destroy() {
        for (String objectName : this.objectNames) {
            try {
                this.exporter.unexport(objectName);
            }
            catch (JmxException jmxException) {}
        }
        this.objectNames.clear();
    }
}

