/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.scheduler.ExecutionSchedule;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class AllAtOnceExecutionSchedule
implements ExecutionSchedule {
    private final Set<SqlStageExecution> schedulingStages;

    public AllAtOnceExecutionSchedule(Collection<SqlStageExecution> stages) {
        Objects.requireNonNull(stages, "stages is null");
        List<PlanFragmentId> preferredScheduleOrder = AllAtOnceExecutionSchedule.getPreferredScheduleOrder((Collection)stages.stream().map(SqlStageExecution::getFragment).collect(ImmutableList.toImmutableList()));
        Ordering ordering = Ordering.explicit(preferredScheduleOrder).onResultOf(PlanFragment::getId).onResultOf(SqlStageExecution::getFragment);
        this.schedulingStages = new LinkedHashSet<SqlStageExecution>(ordering.sortedCopy(stages));
    }

    @Override
    public Set<SqlStageExecution> getStagesToSchedule() {
        Iterator<SqlStageExecution> iterator = this.schedulingStages.iterator();
        while (iterator.hasNext()) {
            StageExecutionState state = iterator.next().getState();
            if (state != StageExecutionState.SCHEDULED && state != StageExecutionState.RUNNING && !state.isDone()) continue;
            iterator.remove();
        }
        return this.schedulingStages;
    }

    @Override
    public boolean isFinished() {
        return this.schedulingStages.isEmpty();
    }

    @VisibleForTesting
    static List<PlanFragmentId> getPreferredScheduleOrder(Collection<PlanFragment> fragments) {
        Set remoteSources = (Set)fragments.stream().map(PlanFragment::getRemoteSourceNodes).flatMap(Collection::stream).map(RemoteSourceNode::getSourceFragmentIds).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        Set rootFragments = (Set)fragments.stream().filter(fragment -> !remoteSources.contains(fragment.getId())).collect(ImmutableSet.toImmutableSet());
        Visitor visitor = new Visitor(fragments);
        rootFragments.forEach(fragment -> visitor.processFragment(fragment.getId()));
        return visitor.getSchedulerOrder();
    }

    private static class Visitor
    extends InternalPlanVisitor<Void, Void> {
        private final Map<PlanFragmentId, PlanFragment> fragments;
        private final ImmutableSet.Builder<PlanFragmentId> schedulerOrder = ImmutableSet.builder();

        public Visitor(Collection<PlanFragment> fragments) {
            this.fragments = (Map)fragments.stream().collect(ImmutableMap.toImmutableMap(PlanFragment::getId, Function.identity()));
        }

        public List<PlanFragmentId> getSchedulerOrder() {
            return ImmutableList.copyOf((Collection)this.schedulerOrder.build());
        }

        public void processFragment(PlanFragmentId planFragmentId) {
            PlanFragment planFragment = this.fragments.get(planFragmentId);
            Preconditions.checkArgument((planFragment != null ? 1 : 0) != 0, (String)"Fragment not found: %s", (Object)planFragmentId);
            planFragment.getRoot().accept((PlanVisitor)this, null);
            this.schedulerOrder.add((Object)planFragmentId);
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            node.getRight().accept((PlanVisitor)this, (Object)context);
            node.getLeft().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            node.getFilteringSource().accept((PlanVisitor)this, (Object)context);
            node.getSource().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Void context) {
            node.getRight().accept((PlanVisitor)this, (Object)context);
            node.getLeft().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Void context) {
            node.getProbeSource().accept((PlanVisitor)this, (Object)context);
            node.getIndexSource().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Void context) {
            node.getSourceFragmentIds().forEach(this::processFragment);
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            for (PlanNode subPlanNode : node.getSources()) {
                subPlanNode.accept((PlanVisitor)this, (Object)context);
            }
            return null;
        }

        @Override
        public Void visitExchange(ExchangeNode node, Void context) {
            for (PlanNode subPlanNode : node.getSources()) {
                subPlanNode.accept((PlanVisitor)this, (Object)context);
            }
            return null;
        }

        public Void visitPlan(PlanNode node, Void context) {
            List sources = node.getSources();
            if (sources.isEmpty()) {
                return null;
            }
            if (sources.size() == 1) {
                ((PlanNode)sources.get(0)).accept((PlanVisitor)this, (Object)context);
                return null;
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }
    }
}

