/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.buffer.PageCodecMarker;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SerializedPage {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SerializedPage.class).instanceSize();
    private final Slice slice;
    private final int positionCount;
    private final int uncompressedSizeInBytes;
    private final byte pageCodecMarkers;

    public SerializedPage(Slice slice, byte pageCodecMarkers, int positionCount, int uncompressedSizeInBytes) {
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.positionCount = positionCount;
        Preconditions.checkArgument((uncompressedSizeInBytes >= 0 ? 1 : 0) != 0, (Object)"uncompressedSizeInBytes is negative");
        this.uncompressedSizeInBytes = uncompressedSizeInBytes;
        this.pageCodecMarkers = pageCodecMarkers;
        if (!PageCodecMarker.ENCRYPTED.isSet(pageCodecMarkers)) {
            if (PageCodecMarker.COMPRESSED.isSet(pageCodecMarkers)) {
                Preconditions.checkArgument((uncompressedSizeInBytes > slice.length() ? 1 : 0) != 0, (Object)"compressed size must be smaller than uncompressed size when compressed");
            } else {
                Preconditions.checkArgument((uncompressedSizeInBytes == slice.length() ? 1 : 0) != 0, (Object)"uncompressed size must be equal to slice length when uncompressed");
            }
        }
    }

    public int getSizeInBytes() {
        return this.slice.length();
    }

    public int getUncompressedSizeInBytes() {
        return this.uncompressedSizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.slice.getRetainedSize();
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public byte getPageCodecMarkers() {
        return this.pageCodecMarkers;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("pageCodecMarkers", (Object)PageCodecMarker.toSummaryString(this.pageCodecMarkers)).add("sizeInBytes", this.slice.length()).add("uncompressedSizeInBytes", this.uncompressedSizeInBytes).toString();
    }
}

