/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.BasicStageExecutionStats;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageExecutionStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.facebook.presto.util.Failures;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class StageExecutionStateMachine {
    private static final Logger log = Logger.get(StageExecutionStateMachine.class);
    private final StageExecutionId stageExecutionId;
    private final SplitSchedulerStats scheduledStats;
    private final boolean containsTableScans;
    private final StateMachine<StageExecutionState> state;
    private final StateMachine<Optional<StageExecutionInfo>> finalInfo;
    private final AtomicReference<ExecutionFailureInfo> failureCause = new AtomicReference();
    private final AtomicReference<DateTime> schedulingComplete = new AtomicReference();
    private final Distribution getSplitDistribution = new Distribution();
    private final AtomicLong peakUserMemory = new AtomicLong();
    private final AtomicLong currentUserMemory = new AtomicLong();
    private final AtomicLong currentTotalMemory = new AtomicLong();

    public StageExecutionStateMachine(StageExecutionId stageExecutionId, ExecutorService executor, SplitSchedulerStats schedulerStats, boolean containsTableScans) {
        this.stageExecutionId = Objects.requireNonNull(stageExecutionId, "stageId is null");
        this.scheduledStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
        this.containsTableScans = containsTableScans;
        this.state = new StateMachine<StageExecutionState>("stage execution " + stageExecutionId, executor, StageExecutionState.PLANNED, StageExecutionState.TERMINAL_STAGE_STATES);
        this.state.addStateChangeListener((T state) -> log.debug("Stage Execution %s is %s", new Object[]{stageExecutionId, state}));
        this.finalInfo = new StateMachine("final stage execution " + stageExecutionId, executor, Optional.empty());
    }

    public StageExecutionId getStageExecutionId() {
        return this.stageExecutionId;
    }

    public StageExecutionState getState() {
        return this.state.get();
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<StageExecutionState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    public synchronized boolean transitionToScheduling() {
        return this.state.compareAndSet(StageExecutionState.PLANNED, StageExecutionState.SCHEDULING);
    }

    public synchronized boolean transitionToFinishedTaskScheduling() {
        return this.state.compareAndSet(StageExecutionState.SCHEDULING, StageExecutionState.FINISHED_TASK_SCHEDULING);
    }

    public synchronized boolean transitionToSchedulingSplits() {
        return this.state.setIf(StageExecutionState.SCHEDULING_SPLITS, currentState -> currentState == StageExecutionState.PLANNED || currentState == StageExecutionState.SCHEDULING || currentState == StageExecutionState.FINISHED_TASK_SCHEDULING);
    }

    public synchronized boolean transitionToScheduled() {
        this.schedulingComplete.compareAndSet(null, DateTime.now());
        return this.state.setIf(StageExecutionState.SCHEDULED, currentState -> currentState == StageExecutionState.PLANNED || currentState == StageExecutionState.SCHEDULING || currentState == StageExecutionState.FINISHED_TASK_SCHEDULING || currentState == StageExecutionState.SCHEDULING_SPLITS);
    }

    public boolean transitionToRunning() {
        return this.state.setIf(StageExecutionState.RUNNING, currentState -> currentState != StageExecutionState.RUNNING && !currentState.isDone());
    }

    public boolean transitionToFinished() {
        return this.state.setIf(StageExecutionState.FINISHED, currentState -> !currentState.isDone());
    }

    public boolean transitionToCanceled() {
        return this.state.setIf(StageExecutionState.CANCELED, currentState -> !currentState.isDone());
    }

    public boolean transitionToAborted() {
        return this.state.setIf(StageExecutionState.ABORTED, currentState -> !currentState.isDone());
    }

    public boolean transitionToFailed(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        this.failureCause.compareAndSet(null, Failures.toFailure(throwable));
        boolean failed = this.state.setIf(StageExecutionState.FAILED, currentState -> !currentState.isDone());
        if (failed) {
            log.error(throwable, "Stage execution %s failed", new Object[]{this.stageExecutionId});
        } else {
            log.debug(throwable, "Failure after stage execution %s finished", new Object[]{this.stageExecutionId});
        }
        return failed;
    }

    public void addFinalStageInfoListener(StateMachine.StateChangeListener<StageExecutionInfo> finalStatusListener) {
        AtomicBoolean done = new AtomicBoolean();
        StateMachine.StateChangeListener<Optional> fireOnceStateChangeListener = finalStageInfo -> {
            if (finalStageInfo.isPresent() && done.compareAndSet(false, true)) {
                finalStatusListener.stateChanged((StageExecutionInfo)finalStageInfo.get());
            }
        };
        this.finalInfo.addStateChangeListener(fireOnceStateChangeListener);
    }

    public void setAllTasksFinal(Iterable<TaskInfo> finalTaskInfos, int totalLifespans) {
        Objects.requireNonNull(finalTaskInfos, "finalTaskInfos is null");
        Preconditions.checkState((boolean)this.state.get().isDone());
        StageExecutionInfo stageInfo = this.getStageExecutionInfo(() -> finalTaskInfos, totalLifespans, totalLifespans);
        Preconditions.checkArgument((boolean)stageInfo.isFinal(), (Object)"finalTaskInfos are not all done");
        this.finalInfo.compareAndSet(Optional.empty(), Optional.of(stageInfo));
    }

    public long getUserMemoryReservation() {
        return this.currentUserMemory.get();
    }

    public long getTotalMemoryReservation() {
        return this.currentTotalMemory.get();
    }

    public void updateMemoryUsage(long deltaUserMemoryInBytes, long deltaTotalMemoryInBytes) {
        this.currentTotalMemory.addAndGet(deltaTotalMemoryInBytes);
        this.currentUserMemory.addAndGet(deltaUserMemoryInBytes);
        this.peakUserMemory.updateAndGet(currentPeakValue -> Math.max(this.currentUserMemory.get(), currentPeakValue));
    }

    public BasicStageExecutionStats getBasicStageStats(Supplier<Iterable<TaskInfo>> taskInfosSupplier) {
        Optional<StageExecutionInfo> finalStageInfo = this.finalInfo.get();
        if (finalStageInfo.isPresent()) {
            return finalStageInfo.get().getStats().toBasicStageStats(finalStageInfo.get().getState());
        }
        StageExecutionState state = this.state.get();
        boolean isScheduled = state == StageExecutionState.RUNNING || state.isDone();
        ImmutableList taskInfos = ImmutableList.copyOf(taskInfosSupplier.get());
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int completedDrivers = 0;
        long cumulativeUserMemory = 0L;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        boolean fullyBlocked = true;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        for (TaskInfo taskInfo : taskInfos) {
            TaskState taskState = taskInfo.getTaskStatus().getState();
            TaskStats taskStats = taskInfo.getStats();
            totalDrivers += taskStats.getTotalDrivers();
            queuedDrivers += taskStats.getQueuedDrivers();
            runningDrivers += taskStats.getRunningDrivers();
            completedDrivers += taskStats.getCompletedDrivers();
            cumulativeUserMemory = (long)((double)cumulativeUserMemory + taskStats.getCumulativeUserMemory());
            long taskUserMemory = taskStats.getUserMemoryReservation().toBytes();
            long taskSystemMemory = taskStats.getSystemMemoryReservation().toBytes();
            userMemoryReservation += taskUserMemory;
            totalMemoryReservation += taskUserMemory + taskSystemMemory;
            totalScheduledTime += taskStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += taskStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            if (!taskState.isDone()) {
                fullyBlocked &= taskStats.isFullyBlocked();
                blockedReasons.addAll(taskStats.getBlockedReasons());
            }
            if (!this.containsTableScans) continue;
            rawInputDataSize += taskStats.getRawInputDataSize().toBytes();
            rawInputPositions += taskStats.getRawInputPositions();
        }
        OptionalDouble progressPercentage = OptionalDouble.empty();
        if (isScheduled && totalDrivers != 0) {
            progressPercentage = OptionalDouble.of(Math.min(100.0, (double)completedDrivers * 100.0 / (double)totalDrivers));
        }
        return new BasicStageExecutionStats(isScheduled, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, cumulativeUserMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), Duration.succinctNanos((long)totalCpuTime), Duration.succinctNanos((long)totalScheduledTime), fullyBlocked, blockedReasons, progressPercentage);
    }

    public StageExecutionInfo getStageExecutionInfo(Supplier<Iterable<TaskInfo>> taskInfosSupplier, int finishedLifespans, int totalLifespans) {
        Optional<StageExecutionInfo> finalStageInfo = this.finalInfo.get();
        if (finalStageInfo.isPresent()) {
            return finalStageInfo.get();
        }
        StageExecutionState state = this.state.get();
        ImmutableList taskInfos = ImmutableList.copyOf(taskInfosSupplier.get());
        int totalTasks = taskInfos.size();
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        long cumulativeUserMemory = 0L;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long peakUserMemoryReservation = this.peakUserMemory.get();
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalBlockedTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long bufferedDataSize = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        long physicalWrittenDataSize = 0L;
        int fullGcCount = 0;
        int fullGcTaskCount = 0;
        int minFullGcSec = 0;
        int maxFullGcSec = 0;
        int totalFullGcSec = 0;
        boolean fullyBlocked = true;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        HashMap<String, OperatorStats> operatorToStats = new HashMap<String, OperatorStats>();
        for (TaskInfo taskInfo : taskInfos) {
            TaskState taskState = taskInfo.getTaskStatus().getState();
            if (taskState.isDone()) {
                ++completedTasks;
            } else {
                ++runningTasks;
            }
            TaskStats taskStats = taskInfo.getStats();
            totalDrivers += taskStats.getTotalDrivers();
            queuedDrivers += taskStats.getQueuedDrivers();
            runningDrivers += taskStats.getRunningDrivers();
            blockedDrivers += taskStats.getBlockedDrivers();
            completedDrivers += taskStats.getCompletedDrivers();
            cumulativeUserMemory = (long)((double)cumulativeUserMemory + taskStats.getCumulativeUserMemory());
            long taskUserMemory = taskStats.getUserMemoryReservation().toBytes();
            long taskSystemMemory = taskStats.getSystemMemoryReservation().toBytes();
            userMemoryReservation += taskUserMemory;
            totalMemoryReservation += taskUserMemory + taskSystemMemory;
            totalScheduledTime += taskStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += taskStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += taskStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            if (!taskState.isDone()) {
                fullyBlocked &= taskStats.isFullyBlocked();
                blockedReasons.addAll(taskStats.getBlockedReasons());
            }
            rawInputDataSize += taskStats.getRawInputDataSize().toBytes();
            rawInputPositions += taskStats.getRawInputPositions();
            processedInputDataSize += taskStats.getProcessedInputDataSize().toBytes();
            processedInputPositions += taskStats.getProcessedInputPositions();
            bufferedDataSize += taskInfo.getOutputBuffers().getTotalBufferedBytes();
            outputDataSize += taskStats.getOutputDataSize().toBytes();
            outputPositions += taskStats.getOutputPositions();
            physicalWrittenDataSize += taskStats.getPhysicalWrittenDataSize().toBytes();
            fullGcCount += taskStats.getFullGcCount();
            fullGcTaskCount += taskStats.getFullGcCount() > 0 ? 1 : 0;
            int gcSec = Math.toIntExact(taskStats.getFullGcTime().roundTo(TimeUnit.SECONDS));
            totalFullGcSec += gcSec;
            minFullGcSec = Math.min(minFullGcSec, gcSec);
            maxFullGcSec = Math.max(maxFullGcSec, gcSec);
            for (PipelineStats pipeline : taskStats.getPipelines()) {
                for (OperatorStats operatorStats : pipeline.getOperatorSummaries()) {
                    String id = pipeline.getPipelineId() + "." + operatorStats.getOperatorId();
                    operatorToStats.compute(id, (k, v) -> v == null ? operatorStats : v.add(operatorStats));
                }
            }
        }
        StageExecutionStats stageExecutionStats = new StageExecutionStats(this.schedulingComplete.get(), this.getSplitDistribution.snapshot(), totalTasks, runningTasks, completedTasks, totalLifespans, finishedLifespans, totalDrivers, queuedDrivers, runningDrivers, blockedDrivers, completedDrivers, cumulativeUserMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), DataSize.succinctBytes((long)peakUserMemoryReservation), Duration.succinctDuration((double)totalScheduledTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)totalCpuTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)totalBlockedTime, (TimeUnit)TimeUnit.NANOSECONDS), fullyBlocked && runningTasks > 0, blockedReasons, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)bufferedDataSize), DataSize.succinctBytes((long)outputDataSize), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), new StageGcStatistics(this.stageExecutionId.getStageId().getId(), this.stageExecutionId.getId(), totalTasks, fullGcTaskCount, minFullGcSec, maxFullGcSec, totalFullGcSec, (int)(1.0 * (double)totalFullGcSec / (double)fullGcCount)), (List<OperatorStats>)ImmutableList.copyOf(operatorToStats.values()));
        Optional<ExecutionFailureInfo> failureInfo = Optional.empty();
        if (state == StageExecutionState.FAILED) {
            failureInfo = Optional.of(this.failureCause.get());
        }
        return new StageExecutionInfo(this.stageExecutionId, state, stageExecutionStats, (List<TaskInfo>)taskInfos, failureInfo);
    }

    public void recordGetSplitTime(long startNanos) {
        long elapsedNanos = System.nanoTime() - startNanos;
        this.getSplitDistribution.add(elapsedNanos);
        this.scheduledStats.getGetSplitTime().add((double)elapsedNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stageExecutionId", (Object)this.stageExecutionId).add("state", this.state).toString();
    }
}

