/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RenameColumnTask
implements DataDefinitionTask<RenameColumn> {
    @Override
    public String getName() {
        return "RENAME COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(RenameColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable());
        TableHandle tableHandle = metadata.getTableHandle(session, tableName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName));
        String source = statement.getSource().getValue().toLowerCase(Locale.ENGLISH);
        String target = statement.getTarget().getValue().toLowerCase(Locale.ENGLISH);
        accessControl.checkCanRenameColumn(session.getRequiredTransactionId(), session.getIdentity(), tableName);
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle);
        ColumnHandle columnHandle = columnHandles.get(source);
        if (columnHandle == null) {
            throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)statement, "Column '%s' does not exist", source);
        }
        if (columnHandles.containsKey(target)) {
            throw new SemanticException(SemanticErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", target);
        }
        if (metadata.getColumnMetadata(session, tableHandle, columnHandle).isHidden()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot rename hidden column", new Object[0]);
        }
        metadata.renameColumn(session, tableHandle, columnHandle, target);
        return Futures.immediateFuture(null);
    }
}

