/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class SystemSplit
implements ConnectorSplit {
    private final ConnectorId connectorId;
    private final SystemTableHandle tableHandle;
    private final List<HostAddress> addresses;
    private final TupleDomain<ColumnHandle> constraint;

    public SystemSplit(ConnectorId connectorId, SystemTableHandle tableHandle, HostAddress address, TupleDomain<ColumnHandle> constraint) {
        this(connectorId, tableHandle, (List<HostAddress>)ImmutableList.of((Object)Objects.requireNonNull(address, "address is null")), constraint);
    }

    @JsonCreator
    public SystemSplit(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="tableHandle") SystemTableHandle tableHandle, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(addresses, "hosts is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"hosts is empty");
        this.addresses = ImmutableList.copyOf(addresses);
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public SystemTableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("tableHandle", (Object)this.tableHandle).add("addresses", this.addresses).toString();
    }
}

