/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class InformationSchemaSplit
implements ConnectorSplit {
    private final InformationSchemaTableHandle tableHandle;
    private final Set<QualifiedTablePrefix> prefixes;
    private final List<HostAddress> addresses;

    @JsonCreator
    public InformationSchemaSplit(@JsonProperty(value="tableHandle") InformationSchemaTableHandle tableHandle, @JsonProperty(value="prefixes") Set<QualifiedTablePrefix> prefixes, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.prefixes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(prefixes, "prefixes is null"));
        Objects.requireNonNull(addresses, "hosts is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"hosts is empty");
        this.addresses = ImmutableList.copyOf(addresses);
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public InformationSchemaTableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public Set<QualifiedTablePrefix> getPrefixes() {
        return this.prefixes;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).add("prefixes", this.prefixes).add("addresses", this.addresses).toString();
    }
}

