/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.spi.relation.LogicalRowExpressions;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpatialJoinUtils {
    public static final FullyQualifiedName ST_CONTAINS = FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_contains");
    public static final FullyQualifiedName ST_CROSSES = FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_crosses");
    public static final FullyQualifiedName ST_EQUALS = FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_equals");
    public static final FullyQualifiedName ST_INTERSECTS = FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_intersects");
    public static final FullyQualifiedName ST_OVERLAPS = FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_overlaps");
    public static final FullyQualifiedName ST_TOUCHES = FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_touches");
    public static final FullyQualifiedName ST_WITHIN = FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_within");
    public static final FullyQualifiedName ST_DISTANCE = FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"st_distance");
    private static final Set<String> ALLOWED_SPATIAL_JOIN_FUNCTIONS = Stream.of(ST_CONTAINS, ST_CROSSES, ST_EQUALS, ST_INTERSECTS, ST_OVERLAPS, ST_TOUCHES, ST_WITHIN).map(FullyQualifiedName::getSuffix).map(String::toLowerCase).collect(Collectors.toSet());

    private SpatialJoinUtils() {
    }

    public static List<FunctionCall> extractSupportedSpatialFunctions(Expression filterExpression) {
        return (List)ExpressionUtils.extractConjuncts(filterExpression).stream().filter(FunctionCall.class::isInstance).map(FunctionCall.class::cast).filter(SpatialJoinUtils::isSupportedSpatialFunction).collect(ImmutableList.toImmutableList());
    }

    public static List<CallExpression> extractSupportedSpatialFunctions(RowExpression filterExpression, FunctionManager functionManager) {
        return (List)LogicalRowExpressions.extractConjuncts((RowExpression)filterExpression).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(call -> SpatialJoinUtils.isSupportedSpatialFunction(call, functionManager)).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialFunction(FunctionCall functionCall) {
        String functionName = functionCall.getName().getSuffix().toLowerCase(Locale.ENGLISH);
        return ALLOWED_SPATIAL_JOIN_FUNCTIONS.contains(functionName);
    }

    private static boolean isSupportedSpatialFunction(CallExpression call, FunctionManager functionManager) {
        String functionName = functionManager.getFunctionMetadata(call.getFunctionHandle()).getName().getSuffix().toLowerCase(Locale.ENGLISH);
        return ALLOWED_SPATIAL_JOIN_FUNCTIONS.contains(functionName);
    }

    public static List<ComparisonExpression> extractSupportedSpatialComparisons(Expression filterExpression) {
        return (List)ExpressionUtils.extractConjuncts(filterExpression).stream().filter(ComparisonExpression.class::isInstance).map(ComparisonExpression.class::cast).filter(SpatialJoinUtils::isSupportedSpatialComparison).collect(ImmutableList.toImmutableList());
    }

    public static List<CallExpression> extractSupportedSpatialComparisons(RowExpression filterExpression, FunctionManager functionManager) {
        return (List)LogicalRowExpressions.extractConjuncts((RowExpression)filterExpression).stream().filter(CallExpression.class::isInstance).map(CallExpression.class::cast).filter(call -> new FunctionResolution(functionManager).isComparisonFunction(call.getFunctionHandle())).filter(call -> SpatialJoinUtils.isSupportedSpatialComparison(call, functionManager)).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialComparison(ComparisonExpression expression) {
        switch (expression.getOperator()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance(expression.getLeft());
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance(expression.getRight());
            }
        }
        return false;
    }

    private static boolean isSupportedSpatialComparison(CallExpression expression, FunctionManager functionManager) {
        FunctionMetadata metadata = functionManager.getFunctionMetadata(expression.getFunctionHandle());
        Preconditions.checkArgument((metadata.getOperatorType().isPresent() && ((OperatorType)metadata.getOperatorType().get()).isComparisonOperator() ? 1 : 0) != 0);
        switch ((OperatorType)metadata.getOperatorType().get()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance((RowExpression)expression.getArguments().get(0), functionManager);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return SpatialJoinUtils.isSTDistance((RowExpression)expression.getArguments().get(1), functionManager);
            }
        }
        return false;
    }

    private static boolean isSTDistance(Expression expression) {
        if (expression instanceof FunctionCall) {
            return ((FunctionCall)expression).getName().getSuffix().equalsIgnoreCase(ST_DISTANCE.getSuffix());
        }
        return false;
    }

    private static boolean isSTDistance(RowExpression expression, FunctionManager functionManager) {
        if (expression instanceof CallExpression) {
            return functionManager.getFunctionMetadata(((CallExpression)expression).getFunctionHandle()).getName().equals((Object)ST_DISTANCE);
        }
        return false;
    }
}

