/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.SignatureBuilder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.JsonOperators;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.JsonCastException;
import com.facebook.presto.util.JsonUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public final class DecimalCasts {
    public static final SqlScalarFunction DECIMAL_TO_BOOLEAN_CAST = DecimalCasts.castFunctionFromDecimalTo(BooleanType.BOOLEAN.getTypeSignature(), "shortDecimalToBoolean", "longDecimalToBoolean");
    public static final SqlScalarFunction BOOLEAN_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(BooleanType.BOOLEAN.getTypeSignature(), "booleanToShortDecimal", "booleanToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_BIGINT_CAST = DecimalCasts.castFunctionFromDecimalTo(BigintType.BIGINT.getTypeSignature(), "shortDecimalToBigint", "longDecimalToBigint");
    public static final SqlScalarFunction BIGINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(BigintType.BIGINT.getTypeSignature(), "bigintToShortDecimal", "bigintToLongDecimal");
    public static final SqlScalarFunction INTEGER_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(IntegerType.INTEGER.getTypeSignature(), "integerToShortDecimal", "integerToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_INTEGER_CAST = DecimalCasts.castFunctionFromDecimalTo(IntegerType.INTEGER.getTypeSignature(), "shortDecimalToInteger", "longDecimalToInteger");
    public static final SqlScalarFunction SMALLINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(SmallintType.SMALLINT.getTypeSignature(), "smallintToShortDecimal", "smallintToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_SMALLINT_CAST = DecimalCasts.castFunctionFromDecimalTo(SmallintType.SMALLINT.getTypeSignature(), "shortDecimalToSmallint", "longDecimalToSmallint");
    public static final SqlScalarFunction TINYINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(TinyintType.TINYINT.getTypeSignature(), "tinyintToShortDecimal", "tinyintToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_TINYINT_CAST = DecimalCasts.castFunctionFromDecimalTo(TinyintType.TINYINT.getTypeSignature(), "shortDecimalToTinyint", "longDecimalToTinyint");
    public static final SqlScalarFunction DECIMAL_TO_DOUBLE_CAST = DecimalCasts.castFunctionFromDecimalTo(DoubleType.DOUBLE.getTypeSignature(), "shortDecimalToDouble", "longDecimalToDouble");
    public static final SqlScalarFunction DOUBLE_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(DoubleType.DOUBLE.getTypeSignature(), "doubleToShortDecimal", "doubleToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_REAL_CAST = DecimalCasts.castFunctionFromDecimalTo(RealType.REAL.getTypeSignature(), "shortDecimalToReal", "longDecimalToReal");
    public static final SqlScalarFunction REAL_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(RealType.REAL.getTypeSignature(), "realToShortDecimal", "realToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_VARCHAR_CAST = DecimalCasts.castFunctionFromDecimalTo(TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x")), "shortDecimalToVarchar", "longDecimalToVarchar");
    public static final SqlScalarFunction VARCHAR_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x")), "varcharToShortDecimal", "varcharToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_JSON_CAST = DecimalCasts.castFunctionFromDecimalTo(JsonType.JSON.getTypeSignature(), "shortDecimalToJson", "longDecimalToJson");
    public static final SqlScalarFunction JSON_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFromBuilder(JsonType.JSON.getTypeSignature(), true, "jsonToShortDecimal", "jsonToLongDecimal");
    private static final double[] DOUBLE_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final float[] FLOAT_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
    private static final Slice MAX_EXACT_DOUBLE = UnscaledDecimal128Arithmetic.unscaledDecimal((long)0xFFFFFFFFFFFFFL);
    private static final Slice MAX_EXACT_FLOAT = UnscaledDecimal128Arithmetic.unscaledDecimal((long)0x3FFFFFL);

    private static SqlScalarFunction castFunctionFromDecimalTo(TypeSignature to, String ... methodNames) {
        Signature signature = SignatureBuilder.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.CAST).argumentTypes(TypeSignature.parseTypeSignature((String)"decimal(precision,scale)", (Set)ImmutableSet.of((Object)"precision", (Object)"scale"))).returnType(to).build();
        return SqlScalarFunction.builder(DecimalCasts.class, OperatorType.CAST).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(methodNames).withExtraParameters(context -> {
            long precision = context.getLiteral("precision");
            long scale = context.getLiteral("scale");
            Number tenToScale = Decimals.isShortDecimal((Type)context.getParameterTypes().get(0)) ? Long.valueOf(Decimals.longTenToNth((int)DecimalCasts.intScale(scale))) : Decimals.bigIntegerTenToNth((int)DecimalCasts.intScale(scale));
            return ImmutableList.of((Object)precision, (Object)scale, (Object)tenToScale);
        }))).build();
    }

    private static SqlScalarFunction castFunctionToDecimalFrom(TypeSignature from, String ... methodNames) {
        return DecimalCasts.castFunctionToDecimalFromBuilder(from, false, methodNames);
    }

    private static SqlScalarFunction castFunctionToDecimalFromBuilder(TypeSignature from, boolean nullableResult, String ... methodNames) {
        Signature signature = SignatureBuilder.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.CAST).argumentTypes(from).returnType(TypeSignature.parseTypeSignature((String)"decimal(precision,scale)", (Set)ImmutableSet.of((Object)"precision", (Object)"scale"))).build();
        return SqlScalarFunction.builder(DecimalCasts.class, OperatorType.CAST).signature(signature).deterministic(true).choice(choice -> choice.nullableResult(nullableResult).implementation(methodsGroup -> methodsGroup.methods(methodNames).withExtraParameters(context -> {
            DecimalType resultType = (DecimalType)context.getReturnType();
            Number tenToScale = Decimals.isShortDecimal((Type)resultType) ? Long.valueOf(Decimals.longTenToNth((int)resultType.getScale())) : Decimals.bigIntegerTenToNth((int)resultType.getScale());
            return ImmutableList.of((Object)resultType.getPrecision(), (Object)resultType.getScale(), (Object)tenToScale);
        }))).build();
    }

    private DecimalCasts() {
    }

    @UsedByGeneratedCode
    public static boolean shortDecimalToBoolean(long decimal, long precision, long scale, long tenToScale) {
        return decimal != 0L;
    }

    @UsedByGeneratedCode
    public static boolean longDecimalToBoolean(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        return !Decimals.decodeUnscaledValue((Slice)decimal).equals(BigInteger.ZERO);
    }

    @UsedByGeneratedCode
    public static long booleanToShortDecimal(boolean value, long precision, long scale, long tenToScale) {
        return value ? tenToScale : 0L;
    }

    @UsedByGeneratedCode
    public static Slice booleanToLongDecimal(boolean value, long precision, long scale, BigInteger tenToScale) {
        return UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)(value ? tenToScale : BigInteger.ZERO));
    }

    @UsedByGeneratedCode
    public static long shortDecimalToBigint(long decimal, long precision, long scale, long tenToScale) {
        if (decimal >= 0L) {
            return (decimal + tenToScale / 2L) / tenToScale;
        }
        return -((-decimal + tenToScale / 2L) / tenToScale);
    }

    @UsedByGeneratedCode
    public static long longDecimalToBigint(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        try {
            return UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)DecimalCasts.intScale(-scale)));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to BIGINT", Decimals.toString((Slice)decimal, (int)DecimalCasts.intScale(scale))));
        }
    }

    @UsedByGeneratedCode
    public static long bigintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice bigintToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        try {
            Slice decimal = UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)value), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)tenToScale));
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long shortDecimalToInteger(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return Math.toIntExact(longResult);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to INTEGER", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToInteger(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        try {
            return Math.toIntExact(UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)DecimalCasts.intScale(-scale))));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to INTEGER", Decimals.toString((Slice)decimal, (int)DecimalCasts.intScale(scale))));
        }
    }

    @UsedByGeneratedCode
    public static long integerToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice integerToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        try {
            Slice decimal = UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)value), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)tenToScale));
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long shortDecimalToSmallint(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return Shorts.checkedCast((long)longResult);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to SMALLINT", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToSmallint(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        try {
            return Shorts.checkedCast((long)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)DecimalCasts.intScale(-scale))));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to SMALLINT", Decimals.toString((Slice)decimal, (int)DecimalCasts.intScale(scale))));
        }
    }

    @UsedByGeneratedCode
    public static long smallintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice smallintToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        try {
            Slice decimal = UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)value), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)tenToScale));
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long shortDecimalToTinyint(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return SignedBytes.checkedCast((long)longResult);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to TINYINT", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToTinyint(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        try {
            return SignedBytes.checkedCast((long)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLong((Slice)UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)DecimalCasts.intScale(-scale))));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to TINYINT", Decimals.toString((Slice)decimal, (int)DecimalCasts.intScale(scale))));
        }
    }

    @UsedByGeneratedCode
    public static long tinyintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice tinyintToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        try {
            Slice decimal = UnscaledDecimal128Arithmetic.multiply((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)value), (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((BigInteger)tenToScale));
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static double shortDecimalToDouble(long decimal, long precision, long scale, long tenToScale) {
        return (double)decimal / (double)tenToScale;
    }

    @UsedByGeneratedCode
    public static double longDecimalToDouble(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        if (scale < (long)DOUBLE_10_POW.length && UnscaledDecimal128Arithmetic.compareAbsolute((Slice)decimal, (Slice)MAX_EXACT_DOUBLE) <= 0) {
            return (double)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLongUnsafe((Slice)decimal) / DOUBLE_10_POW[DecimalCasts.intScale(scale)];
        }
        return Double.parseDouble(Decimals.toString((Slice)decimal, (int)DecimalCasts.intScale(scale)));
    }

    @UsedByGeneratedCode
    public static long shortDecimalToReal(long decimal, long precision, long scale, long tenToScale) {
        return Float.floatToRawIntBits((float)decimal / (float)tenToScale);
    }

    @UsedByGeneratedCode
    public static long longDecimalToReal(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        if (scale < (long)FLOAT_10_POW.length && UnscaledDecimal128Arithmetic.compareAbsolute((Slice)decimal, (Slice)MAX_EXACT_FLOAT) <= 0) {
            return Float.floatToRawIntBits((float)UnscaledDecimal128Arithmetic.unscaledDecimalToUnscaledLongUnsafe((Slice)decimal) / FLOAT_10_POW[DecimalCasts.intScale(scale)]);
        }
        return Float.floatToRawIntBits(Float.parseFloat(Decimals.toString((Slice)decimal, (int)DecimalCasts.intScale(scale))));
    }

    @UsedByGeneratedCode
    public static long doubleToShortDecimal(double value, long precision, long scale, long tenToScale) {
        Slice decimal = DecimalCasts.internalDoubleToLongDecimal(value, precision, scale);
        long low = UnscaledDecimal128Arithmetic.getLong((Slice)decimal, (int)0);
        long high = UnscaledDecimal128Arithmetic.getLong((Slice)decimal, (int)1);
        Preconditions.checkState((high == 0L && low >= 0L ? 1 : 0) != 0, (Object)"Unexpected long decimal");
        if (UnscaledDecimal128Arithmetic.isNegative((Slice)decimal)) {
            return -low;
        }
        return low;
    }

    @UsedByGeneratedCode
    public static Slice doubleToLongDecimal(double value, long precision, long scale, BigInteger tenToScale) {
        return DecimalCasts.internalDoubleToLongDecimal(value, precision, scale);
    }

    private static Slice internalDoubleToLongDecimal(double value, long precision, long scale) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DOUBLE '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
        try {
            BigDecimal bigDecimal = BigDecimal.valueOf(value).setScale(DecimalCasts.intScale(scale), RoundingMode.HALF_UP);
            Slice decimal = Decimals.encodeScaledValue((BigDecimal)bigDecimal);
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DOUBLE '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DOUBLE '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long realToShortDecimal(long value, long precision, long scale, long tenToScale) {
        Slice decimal = DecimalCasts.realToLongDecimal(value, precision, scale);
        long low = UnscaledDecimal128Arithmetic.getLong((Slice)decimal, (int)0);
        long high = UnscaledDecimal128Arithmetic.getLong((Slice)decimal, (int)1);
        Preconditions.checkState((high == 0L && low >= 0L ? 1 : 0) != 0, (Object)"Unexpected long decimal");
        if (UnscaledDecimal128Arithmetic.isNegative((Slice)decimal)) {
            return -low;
        }
        return low;
    }

    @UsedByGeneratedCode
    public static Slice realToLongDecimal(long value, long precision, long scale, BigInteger tenToScale) {
        return DecimalCasts.realToLongDecimal(value, precision, scale);
    }

    private static Slice realToLongDecimal(long value, long precision, long scale) {
        float floatValue = Float.intBitsToFloat(DecimalCasts.intScale(value));
        if (Float.isInfinite(floatValue) || Float.isNaN(floatValue)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast REAL '%s' to DECIMAL(%s, %s)", Float.valueOf(floatValue), precision, scale));
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(floatValue)).setScale(DecimalCasts.intScale(scale), RoundingMode.HALF_UP);
            Slice decimal = Decimals.encodeScaledValue((BigDecimal)bigDecimal);
            if (UnscaledDecimal128Arithmetic.overflows((Slice)decimal, (int)DecimalCasts.intScale(precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast REAL '%s' to DECIMAL(%s, %s)", Float.valueOf(floatValue), precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast REAL '%s' to DECIMAL(%s, %s)", Float.valueOf(floatValue), precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToVarchar(long decimal, long precision, long scale, long tenToScale) {
        return Slices.utf8Slice((String)Decimals.toString((long)decimal, (int)DecimalCasts.intScale(scale)));
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToVarchar(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        return Slices.utf8Slice((String)Decimals.toString((Slice)decimal, (int)DecimalCasts.intScale(scale)));
    }

    @UsedByGeneratedCode
    public static long varcharToShortDecimal(Slice value, long precision, long scale, long tenToScale) {
        BigDecimal result;
        String stringValue = value.toString(StandardCharsets.UTF_8);
        try {
            result = new BigDecimal(stringValue).setScale(DecimalCasts.intScale(scale), RoundingMode.HALF_UP);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value is not a number.", stringValue, precision, scale));
        }
        if (Decimals.overflows((BigDecimal)result, (long)precision)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value too large.", stringValue, precision, scale));
        }
        return result.unscaledValue().longValue();
    }

    @UsedByGeneratedCode
    public static Slice varcharToLongDecimal(Slice value, long precision, long scale, BigInteger tenToScale) {
        BigDecimal result;
        String stringValue = value.toString(StandardCharsets.UTF_8);
        try {
            result = new BigDecimal(stringValue).setScale(DecimalCasts.intScale(scale), RoundingMode.HALF_UP);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value is not a number.", stringValue, precision, scale));
        }
        if (Decimals.overflows((BigDecimal)result, (long)precision)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value too large.", stringValue, precision, scale));
        }
        return Decimals.encodeUnscaledValue((BigInteger)result.unscaledValue());
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToJson(long decimal, long precision, long scale, long tenToScale) {
        return DecimalCasts.decimalToJson(BigDecimal.valueOf(decimal, DecimalCasts.intScale(scale)));
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToJson(Slice decimal, long precision, long scale, BigInteger tenToScale) {
        return DecimalCasts.decimalToJson(new BigDecimal(Decimals.decodeUnscaledValue((Slice)decimal), DecimalCasts.intScale(scale)));
    }

    private static Slice decimalToJson(BigDecimal bigDecimal) {
        try {
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(32);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)dynamicSliceOutput);){
                jsonGenerator.writeNumber(bigDecimal);
            }
            return dynamicSliceOutput.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%f' to %s", bigDecimal, "json"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Slice jsonToLongDecimal(Slice json, long precision, long scale, BigInteger tenToScale) {
        try (JsonParser parser = JsonUtil.createJsonParser(JsonOperators.JSON_FACTORY, json);){
            parser.nextToken();
            Slice result = JsonUtil.currentTokenAsLongDecimal(parser, DecimalCasts.intPrecision(precision), DecimalCasts.intScale(scale));
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DECIMAL(%s,%s)", precision, scale);
            Slice slice = result;
            return slice;
        }
        catch (JsonCastException | IOException | NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to DECIMAL(%s,%s)", json.toStringUtf8(), precision, scale), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Long jsonToShortDecimal(Slice json, long precision, long scale, long tenToScale) {
        try (JsonParser parser = JsonUtil.createJsonParser(JsonOperators.JSON_FACTORY, json);){
            parser.nextToken();
            Long result = JsonUtil.currentTokenAsShortDecimal(parser, DecimalCasts.intPrecision(precision), DecimalCasts.intScale(scale));
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DECIMAL(%s,%s)", precision, scale);
            Long l = result;
            return l;
        }
        catch (JsonCastException | IOException | NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to DECIMAL(%s,%s)", json.toStringUtf8(), precision, scale), (Throwable)e);
        }
    }

    private static int intPrecision(long precision) {
        return (int)precision;
    }

    private static int intScale(long scale) {
        return (int)scale;
    }
}

