/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.PagesIndexPageSorter;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.connector.ConnectorAwareNodeManager;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.PredicateCompiler;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.RowExpressionPredicateCompiler;
import com.facebook.presto.sql.planner.planPrinter.RowExpressionFormatter;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.facebook.presto.type.TypeRegistry;

public class TestingConnectorContext
implements ConnectorContext {
    private final NodeManager nodeManager = new ConnectorAwareNodeManager(new InMemoryNodeManager(), "testenv", new ConnectorId("test"));
    private final TypeManager typeManager = new TypeRegistry();
    private final FunctionManager functionManager = new FunctionManager(this.typeManager, new BlockEncodingManager(this.typeManager, new BlockEncoding[0]), new FeaturesConfig());
    private final StandardFunctionResolution functionResolution = new FunctionResolution(this.functionManager);
    private final PageSorter pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory(false));
    private final PageIndexerFactory pageIndexerFactory = new GroupByHashPageIndexerFactory(new JoinCompiler(MetadataManager.createTestMetadataManager(), new FeaturesConfig()));
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final DomainTranslator domainTranslator = new RowExpressionDomainTranslator(this.metadata);
    private final PredicateCompiler predicateCompiler = new RowExpressionPredicateCompiler(this.metadata);
    private final DeterminismEvaluator determinismEvaluator = new RowExpressionDeterminismEvaluator(this.functionManager);

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public FunctionMetadataManager getFunctionMetadataManager() {
        return this.functionManager;
    }

    public StandardFunctionResolution getStandardFunctionResolution() {
        return this.functionResolution;
    }

    public PageSorter getPageSorter() {
        return this.pageSorter;
    }

    public PageIndexerFactory getPageIndexerFactory() {
        return this.pageIndexerFactory;
    }

    public RowExpressionService getRowExpressionService() {
        return new RowExpressionService(){

            public DomainTranslator getDomainTranslator() {
                return TestingConnectorContext.this.domainTranslator;
            }

            public ExpressionOptimizer getExpressionOptimizer() {
                return new RowExpressionOptimizer(TestingConnectorContext.this.metadata);
            }

            public PredicateCompiler getPredicateCompiler() {
                return TestingConnectorContext.this.predicateCompiler;
            }

            public DeterminismEvaluator getDeterminismEvaluator() {
                return TestingConnectorContext.this.determinismEvaluator;
            }

            public String formatRowExpression(ConnectorSession session, RowExpression expression) {
                return new RowExpressionFormatter(TestingConnectorContext.this.functionManager).formatRowExpression(session, expression);
            }
        };
    }
}

