/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TypeValidator
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        plan.accept((PlanVisitor)new Visitor(session, metadata, sqlParser, types, warningCollector), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Session session;
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final TypeProvider types;
        private final WarningCollector warningCollector;

        public Visitor(Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            AggregationNode.Step step = node.getStep();
            switch (step) {
                case SINGLE: {
                    this.checkFunctionSignature(node.getAggregations());
                    this.checkAggregation(node.getAggregations());
                    break;
                }
                case FINAL: {
                    this.checkFunctionSignature(node.getAggregations());
                }
            }
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            this.checkWindowFunctions(node.getWindowFunctions());
            return null;
        }

        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (Map.Entry entry : node.getAssignments().entrySet()) {
                RowExpression expression = (RowExpression)entry.getValue();
                if (OriginalExpressionUtils.isExpression(expression)) {
                    if (OriginalExpressionUtils.castToExpression(expression) instanceof SymbolReference) {
                        SymbolReference symbolReference = (SymbolReference)OriginalExpressionUtils.castToExpression(expression);
                        this.verifyTypeSignature((VariableReferenceExpression)entry.getKey(), this.types.get((Expression)symbolReference).getTypeSignature());
                        continue;
                    }
                    Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, OriginalExpressionUtils.castToExpression(expression), Collections.emptyList(), this.warningCollector);
                    Type actualType = expressionTypes.get(NodeRef.of((Node)OriginalExpressionUtils.castToExpression(expression)));
                    this.verifyTypeSignature((VariableReferenceExpression)entry.getKey(), actualType.getTypeSignature());
                    continue;
                }
                Type actualType = expression.getType();
                this.verifyTypeSignature((VariableReferenceExpression)entry.getKey(), actualType.getTypeSignature());
            }
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            ListMultimap<VariableReferenceExpression, VariableReferenceExpression> variableMapping = node.getVariableMapping();
            for (VariableReferenceExpression keyVariable : variableMapping.keySet()) {
                List valueVariables = variableMapping.get((Object)keyVariable);
                for (VariableReferenceExpression valueVariable : valueVariables) {
                    this.verifyTypeSignature(keyVariable, valueVariable.getType().getTypeSignature());
                }
            }
            return null;
        }

        private void checkWindowFunctions(Map<VariableReferenceExpression, WindowNode.Function> functions) {
            for (Map.Entry<VariableReferenceExpression, WindowNode.Function> entry : functions.entrySet()) {
                FunctionHandle functionHandle = entry.getValue().getFunctionHandle();
                CallExpression call = entry.getValue().getFunctionCall();
                this.verifyTypeSignature(entry.getKey(), this.metadata.getFunctionManager().getFunctionMetadata(functionHandle).getReturnType());
                this.checkCall(entry.getKey(), call);
            }
        }

        private void checkCall(VariableReferenceExpression variable, CallExpression call) {
            Type actualType = call.getType();
            this.verifyTypeSignature(variable, actualType.getTypeSignature());
        }

        private void checkFunctionSignature(Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations) {
            for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                this.verifyTypeSignature(entry.getKey(), this.metadata.getFunctionManager().getFunctionMetadata(entry.getValue().getFunctionHandle()).getReturnType());
            }
        }

        private void checkAggregation(Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations) {
            for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                VariableReferenceExpression variable = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                FunctionMetadata functionMetadata = this.metadata.getFunctionManager().getFunctionMetadata(aggregation.getFunctionHandle());
                this.verifyTypeSignature(variable, functionMetadata.getReturnType());
                this.verifyTypeSignature(variable, aggregation.getCall().getType().getTypeSignature());
                int argumentSize = aggregation.getArguments().size();
                int expectedArgumentSize = functionMetadata.getArgumentTypes().size();
                Preconditions.checkArgument((argumentSize == functionMetadata.getArgumentTypes().size() ? 1 : 0) != 0, (String)"Number of arguments is different from function signature: expected %s but got %s", (int)expectedArgumentSize, (int)argumentSize);
                List argumentTypes = (List)aggregation.getArguments().stream().map(argument -> OriginalExpressionUtils.isExpression(argument) ? UnknownType.UNKNOWN.getTypeSignature() : argument.getType().getTypeSignature()).collect(ImmutableList.toImmutableList());
                for (int i = 0; i < functionMetadata.getArgumentTypes().size(); ++i) {
                    TypeSignature expected = (TypeSignature)functionMetadata.getArgumentTypes().get(i);
                    TypeSignature actual = (TypeSignature)argumentTypes.get(i);
                    TypeManager typeManager = this.metadata.getTypeManager();
                    if (actual.equals((Object)UnknownType.UNKNOWN.getTypeSignature()) || typeManager.isTypeOnlyCoercion(typeManager.getType(actual), typeManager.getType(expected))) continue;
                    Preconditions.checkArgument((boolean)expected.equals((Object)actual), (String)"Expected input types are %s but getting %s", (Object)functionMetadata.getArgumentTypes(), (Object)argumentTypes);
                }
            }
        }

        private void verifyTypeSignature(VariableReferenceExpression variable, TypeSignature actual) {
            TypeManager typeManager = this.metadata.getTypeManager();
            if (!actual.equals((Object)UnknownType.UNKNOWN.getTypeSignature()) && !typeManager.isTypeOnlyCoercion(typeManager.getType(actual), variable.getType())) {
                Preconditions.checkArgument((boolean)variable.getType().getTypeSignature().equals((Object)actual), (String)"type of variable '%s' is expected to be %s, but the actual type is %s", (Object)variable.getName(), (Object)variable.getType(), (Object)actual);
            }
        }
    }
}

