/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableWriterNode
extends InternalPlanNode {
    private final PlanNode source;
    private final WriterTarget target;
    private final VariableReferenceExpression rowCountVariable;
    private final VariableReferenceExpression fragmentVariable;
    private final VariableReferenceExpression tableCommitContextVariable;
    private final List<VariableReferenceExpression> columns;
    private final List<String> columnNames;
    private final Optional<PartitioningScheme> partitioningScheme;
    private final Optional<StatisticAggregations> statisticsAggregation;
    private final List<VariableReferenceExpression> outputs;

    @JsonCreator
    public TableWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") WriterTarget target, @JsonProperty(value="rowCountVariable") VariableReferenceExpression rowCountVariable, @JsonProperty(value="fragmentVariable") VariableReferenceExpression fragmentVariable, @JsonProperty(value="tableCommitContextVariable") VariableReferenceExpression tableCommitContextVariable, @JsonProperty(value="columns") List<VariableReferenceExpression> columns, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="partitioningScheme") Optional<PartitioningScheme> partitioningScheme, @JsonProperty(value="statisticsAggregation") Optional<StatisticAggregations> statisticsAggregation) {
        super(id);
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Preconditions.checkArgument((columns.size() == columnNames.size() ? 1 : 0) != 0, (Object)"columns and columnNames sizes don't match");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountVariable = Objects.requireNonNull(rowCountVariable, "rowCountVariable is null");
        this.fragmentVariable = Objects.requireNonNull(fragmentVariable, "fragmentVariable is null");
        this.tableCommitContextVariable = Objects.requireNonNull(tableCommitContextVariable, "tableCommitContextVariable is null");
        this.columns = ImmutableList.copyOf(columns);
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        this.statisticsAggregation = Objects.requireNonNull(statisticsAggregation, "statisticsAggregation is null");
        ImmutableList.Builder outputs = ImmutableList.builder().add((Object)rowCountVariable).add((Object)fragmentVariable).add((Object)tableCommitContextVariable);
        statisticsAggregation.ifPresent(aggregation -> {
            outputs.addAll(aggregation.getGroupingVariables());
            outputs.addAll(aggregation.getAggregations().keySet());
        });
        this.outputs = outputs.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public WriterTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public VariableReferenceExpression getRowCountVariable() {
        return this.rowCountVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getFragmentVariable() {
        return this.fragmentVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getTableCommitContextVariable() {
        return this.tableCommitContextVariable;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public Optional<StatisticAggregations> getStatisticsAggregation() {
        return this.statisticsAggregation;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputs;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableWriter(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TableWriterNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowCountVariable, this.fragmentVariable, this.tableCommitContextVariable, this.columns, this.columnNames, this.partitioningScheme, this.statisticsAggregation);
    }

    public static class DeleteHandle
    extends WriterTarget {
        private final TableHandle handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public DeleteHandle(@JsonProperty(value="handle") TableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public TableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class InsertHandle
    extends WriterTarget {
        private final InsertTableHandle handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public InsertHandle(@JsonProperty(value="handle") InsertTableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public InsertTableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class InsertReference
    extends WriterTarget {
        private final TableHandle handle;

        public InsertReference(TableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class CreateHandle
    extends WriterTarget {
        private final OutputTableHandle handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public CreateHandle(@JsonProperty(value="handle") OutputTableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public OutputTableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class CreateName
    extends WriterTarget {
        private final String catalog;
        private final ConnectorTableMetadata tableMetadata;
        private final Optional<NewTableLayout> layout;

        public CreateName(String catalog, ConnectorTableMetadata tableMetadata, Optional<NewTableLayout> layout) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
            this.layout = Objects.requireNonNull(layout, "layout is null");
        }

        public String getCatalog() {
            return this.catalog;
        }

        public ConnectorTableMetadata getTableMetadata() {
            return this.tableMetadata;
        }

        public Optional<NewTableLayout> getLayout() {
            return this.layout;
        }

        @Override
        public String toString() {
            return this.catalog + "." + this.tableMetadata.getTable();
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CreateHandle.class, name="CreateHandle"), @JsonSubTypes.Type(value=InsertHandle.class, name="InsertHandle"), @JsonSubTypes.Type(value=DeleteHandle.class, name="DeleteHandle")})
    public static abstract class WriterTarget {
        public abstract String toString();
    }
}

