/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.AnalyzeTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;

public class StatisticsWriterNode
extends InternalPlanNode {
    private final PlanNode source;
    private final VariableReferenceExpression rowCountVariable;
    private final WriteStatisticsTarget target;
    private final boolean rowCountEnabled;
    private final StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor;

    @JsonCreator
    public StatisticsWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") WriteStatisticsTarget target, @JsonProperty(value="rowCountVariable") VariableReferenceExpression rowCountVariable, @JsonProperty(value="rowCountEnabled") boolean rowCountEnabled, @JsonProperty(value="descriptor") StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountVariable = Objects.requireNonNull(rowCountVariable, "rowCountVariable is null");
        this.rowCountEnabled = rowCountEnabled;
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public WriteStatisticsTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public StatisticAggregationsDescriptor<VariableReferenceExpression> getDescriptor() {
        return this.descriptor;
    }

    @JsonProperty
    public VariableReferenceExpression getRowCountVariable() {
        return this.rowCountVariable;
    }

    @JsonProperty
    public boolean isRowCountEnabled() {
        return this.rowCountEnabled;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.of((Object)this.rowCountVariable);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new StatisticsWriterNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowCountVariable, this.rowCountEnabled, this.descriptor);
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitStatisticsWriterNode(this, context);
    }

    @VisibleForTesting
    public static class TestWriteStatisticsHandle
    extends WriteStatisticsTarget {
        @Override
        public String toString() {
            return "test";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return Objects.hashCode("test");
        }
    }

    public static class WriteStatisticsReference
    extends WriteStatisticsTarget {
        private final TableHandle handle;

        public WriteStatisticsReference(TableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class WriteStatisticsHandle
    extends WriteStatisticsTarget {
        private final AnalyzeTableHandle handle;

        @JsonCreator
        public WriteStatisticsHandle(@JsonProperty(value="handle") AnalyzeTableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        @JsonProperty
        public AnalyzeTableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=WriteStatisticsHandle.class, name="WriteStatisticsHandle"), @JsonSubTypes.Type(value=TestWriteStatisticsHandle.class, name="TestWriteStatisticsHandle")})
    public static abstract class WriteStatisticsTarget {
        public abstract String toString();
    }
}

