/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.util.MoreLists;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExchangeNode
extends InternalPlanNode {
    private final Type type;
    private final Scope scope;
    private final List<PlanNode> sources;
    private final PartitioningScheme partitioningScheme;
    private final List<List<VariableReferenceExpression>> inputs;
    private final Optional<OrderingScheme> orderingScheme;

    /*
     * Unable to fully structure code
     */
    @JsonCreator
    public ExchangeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="scope") Scope scope, @JsonProperty(value="partitioningScheme") PartitioningScheme partitioningScheme, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="inputs") List<List<VariableReferenceExpression>> inputs, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme) {
        super(id);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        Objects.requireNonNull(inputs, "inputs is null");
        Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        Preconditions.checkArgument((boolean)(inputs.isEmpty() == false), (Object)"inputs is empty");
        Preconditions.checkArgument((boolean)inputs.stream().allMatch((Predicate<List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(com.facebook.presto.sql.planner.PartitioningScheme java.util.List ), (Ljava/util/List;)Z)((PartitioningScheme)partitioningScheme)), (Object)"Input symbols do not match output symbols");
        Preconditions.checkArgument((boolean)(inputs.size() == sources.size()), (Object)"Must have same number of input lists as sources");
        for (i = 0; i < inputs.size(); ++i) {
            Preconditions.checkArgument((boolean)sources.get(i).getOutputVariables().containsAll((Collection)inputs.get(i)), (Object)"Source does not supply all required input variables");
        }
        if (!scope.isLocal()) ** GOTO lbl-1000
        if (partitioningScheme.getPartitioning().getArguments().stream().allMatch((Predicate<RowExpression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lcom/facebook/presto/spi/relation/RowExpression;)Z)(VariableReferenceExpression.class))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        Preconditions.checkArgument((boolean)v0, (Object)"local exchanges do not support constant partition function arguments");
        Preconditions.checkArgument((boolean)(scope.isRemote() == false || type == Type.REPARTITION || partitioningScheme.isReplicateNullsAndAny() == false), (Object)"Only REPARTITION can replicate remotely");
        Preconditions.checkArgument((boolean)(scope != Scope.REMOTE_MATERIALIZED || type == Type.REPARTITION), (String)"Only REPARTITION can be REMOTE_MATERIALIZED: %s", (Object)type);
        orderingScheme.ifPresent((Consumer<OrderingScheme>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$new$1(com.facebook.presto.sql.planner.PartitioningScheme com.facebook.presto.sql.planner.plan.ExchangeNode$Scope com.facebook.presto.spi.plan.OrderingScheme ), (Lcom/facebook/presto/spi/plan/OrderingScheme;)V)((PartitioningScheme)partitioningScheme, (Scope)scope));
        this.type = type;
        this.sources = sources;
        this.scope = scope;
        this.partitioningScheme = partitioningScheme;
        this.inputs = MoreLists.listOfListsCopy(inputs);
        this.orderingScheme = orderingScheme;
    }

    public static ExchangeNode systemPartitionedExchange(PlanNodeId id, Scope scope, PlanNode child, List<VariableReferenceExpression> partitioningColumns, Optional<VariableReferenceExpression> hashColumn) {
        return ExchangeNode.systemPartitionedExchange(id, scope, child, partitioningColumns, hashColumn, false);
    }

    public static ExchangeNode systemPartitionedExchange(PlanNodeId id, Scope scope, PlanNode child, List<VariableReferenceExpression> partitioningColumns, Optional<VariableReferenceExpression> hashColumn, boolean replicateNullsAndAny) {
        return ExchangeNode.partitionedExchange(id, scope, child, Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, partitioningColumns), hashColumn, replicateNullsAndAny);
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, Scope scope, PlanNode child, Partitioning partitioning, Optional<VariableReferenceExpression> hashColumn) {
        return ExchangeNode.partitionedExchange(id, scope, child, partitioning, hashColumn, false);
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, Scope scope, PlanNode child, Partitioning partitioning, Optional<VariableReferenceExpression> hashColumn, boolean replicateNullsAndAny) {
        return ExchangeNode.partitionedExchange(id, scope, child, new PartitioningScheme(partitioning, child.getOutputVariables(), hashColumn, replicateNullsAndAny, Optional.empty()));
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, Scope scope, PlanNode child, PartitioningScheme partitioningScheme) {
        if (partitioningScheme.getPartitioning().getHandle().isSingleNode()) {
            return ExchangeNode.gatheringExchange(id, scope, child);
        }
        return new ExchangeNode(id, Type.REPARTITION, scope, partitioningScheme, (List<PlanNode>)ImmutableList.of((Object)child), (List<List<VariableReferenceExpression>>)ImmutableList.of(partitioningScheme.getOutputLayout()), Optional.empty());
    }

    public static ExchangeNode replicatedExchange(PlanNodeId id, Scope scope, PlanNode child) {
        return new ExchangeNode(id, Type.REPLICATE, scope, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, (List<VariableReferenceExpression>)ImmutableList.of()), child.getOutputVariables()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<VariableReferenceExpression>>)ImmutableList.of((Object)child.getOutputVariables()), Optional.empty());
    }

    public static ExchangeNode gatheringExchange(PlanNodeId id, Scope scope, PlanNode child) {
        return new ExchangeNode(id, Type.GATHER, scope, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<VariableReferenceExpression>)ImmutableList.of()), child.getOutputVariables()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<VariableReferenceExpression>>)ImmutableList.of((Object)child.getOutputVariables()), Optional.empty());
    }

    public static ExchangeNode roundRobinExchange(PlanNodeId id, Scope scope, PlanNode child) {
        return ExchangeNode.partitionedExchange(id, scope, child, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<VariableReferenceExpression>)ImmutableList.of()), child.getOutputVariables()));
    }

    public static ExchangeNode mergingExchange(PlanNodeId id, Scope scope, PlanNode child, OrderingScheme orderingScheme) {
        PartitioningHandle partitioningHandle = scope.isLocal() ? SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION : SystemPartitioningHandle.SINGLE_DISTRIBUTION;
        return new ExchangeNode(id, Type.GATHER, scope, new PartitioningScheme(Partitioning.create(partitioningHandle, (List<VariableReferenceExpression>)ImmutableList.of()), child.getOutputVariables()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<VariableReferenceExpression>>)ImmutableList.of((Object)child.getOutputVariables()), Optional.of(orderingScheme));
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Scope getScope() {
        return this.scope;
    }

    @JsonProperty
    public List<PlanNode> getSources() {
        return this.sources;
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.partitioningScheme.getOutputLayout();
    }

    @JsonProperty
    public PartitioningScheme getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public Optional<OrderingScheme> getOrderingScheme() {
        return this.orderingScheme;
    }

    @JsonProperty
    public List<List<VariableReferenceExpression>> getInputs() {
        return this.inputs;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitExchange(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ExchangeNode(this.getId(), this.type, this.scope, this.partitioningScheme, newChildren, this.inputs, this.orderingScheme);
    }

    private static /* synthetic */ void lambda$new$1(@JsonProperty(value="partitioningScheme") PartitioningScheme partitioningScheme, @JsonProperty(value="scope") Scope scope, OrderingScheme ordering) {
        PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
        Preconditions.checkArgument((!scope.isRemote() || partitioningHandle.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) ? 1 : 0) != 0, (Object)"remote merging exchange requires single distribution");
        Preconditions.checkArgument((!scope.isLocal() || partitioningHandle.equals(SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION) ? 1 : 0) != 0, (Object)"local merging exchange requires passthrough distribution");
        Preconditions.checkArgument((boolean)partitioningScheme.getOutputLayout().containsAll(ordering.getOrderByVariables()), (Object)"Partitioning scheme does not supply all required ordering symbols");
    }

    private static /* synthetic */ boolean lambda$new$0(@JsonProperty(value="partitioningScheme") PartitioningScheme partitioningScheme, List inputVariables) {
        return inputVariables.size() == partitioningScheme.getOutputLayout().size();
    }

    public static enum Scope {
        LOCAL(false),
        REMOTE_STREAMING(true),
        REMOTE_MATERIALIZED(true);

        private boolean remote;

        private Scope(boolean remote) {
            this.remote = remote;
        }

        public boolean isRemote() {
            return this.remote;
        }

        public boolean isLocal() {
            return !this.isRemote();
        }
    }

    public static enum Type {
        GATHER,
        REPARTITION,
        REPLICATE;

    }
}

