/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DistinctLimitNode
extends InternalPlanNode {
    private final PlanNode source;
    private final long limit;
    private final boolean partial;
    private final List<VariableReferenceExpression> distinctVariables;
    private final Optional<VariableReferenceExpression> hashVariable;

    @JsonCreator
    public DistinctLimitNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="limit") long limit, @JsonProperty(value="partial") boolean partial, @JsonProperty(value="distinctVariables") List<VariableReferenceExpression> distinctVariables, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be greater than or equal to zero");
        this.limit = limit;
        this.partial = partial;
        this.distinctVariables = ImmutableList.copyOf(distinctVariables);
        this.hashVariable = Objects.requireNonNull(hashVariable, "hashVariable is null");
        Preconditions.checkArgument((!hashVariable.isPresent() || !distinctVariables.contains(hashVariable.get()) ? 1 : 0) != 0, (Object)"distinctVariables should not contain hash variable");
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public long getLimit() {
        return this.limit;
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getDistinctVariables() {
        return this.distinctVariables;
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        ImmutableList.Builder outputVariables = ImmutableList.builder();
        outputVariables.addAll(this.distinctVariables);
        this.hashVariable.ifPresent(arg_0 -> ((ImmutableList.Builder)outputVariables).add(arg_0));
        return outputVariables.build();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitDistinctLimit(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new DistinctLimitNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.limit, this.partial, this.distinctVariables, this.hashVariable);
    }
}

