/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.optimizations.ApplyNodeUtil;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ApplyNode
extends InternalPlanNode {
    private final PlanNode input;
    private final PlanNode subquery;
    private final List<VariableReferenceExpression> correlation;
    private final Assignments subqueryAssignments;
    private final String originSubqueryError;

    @JsonCreator
    public ApplyNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="input") PlanNode input, @JsonProperty(value="subquery") PlanNode subquery, @JsonProperty(value="subqueryAssignments") Assignments subqueryAssignments, @JsonProperty(value="correlation") List<VariableReferenceExpression> correlation, @JsonProperty(value="originSubqueryError") String originSubqueryError) {
        super(id);
        Objects.requireNonNull(input, "input is null");
        Objects.requireNonNull(subquery, "right is null");
        Objects.requireNonNull(subqueryAssignments, "assignments is null");
        Objects.requireNonNull(correlation, "correlation is null");
        Objects.requireNonNull(originSubqueryError, "originSubqueryError is null");
        Preconditions.checkArgument((boolean)input.getOutputVariables().containsAll(correlation), (Object)"Input does not contain symbols from correlation");
        Preconditions.checkArgument((boolean)subqueryAssignments.getExpressions().stream().map(OriginalExpressionUtils::castToExpression).allMatch(ApplyNodeUtil::isSupportedSubqueryExpression), (Object)"Unexpected expression used for subquery expression");
        this.input = input;
        this.subquery = subquery;
        this.subqueryAssignments = subqueryAssignments;
        this.correlation = ImmutableList.copyOf(correlation);
        this.originSubqueryError = originSubqueryError;
    }

    @JsonProperty
    public PlanNode getInput() {
        return this.input;
    }

    @JsonProperty
    public PlanNode getSubquery() {
        return this.subquery;
    }

    @JsonProperty
    public Assignments getSubqueryAssignments() {
        return this.subqueryAssignments;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getCorrelation() {
        return this.correlation;
    }

    @JsonProperty
    public String getOriginSubqueryError() {
        return this.originSubqueryError;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.input, (Object)this.subquery);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.input.getOutputVariables()).addAll((Iterable)this.subqueryAssignments.getOutputs()).build();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitApply(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new ApplyNode(this.getId(), newChildren.get(0), newChildren.get(1), this.subqueryAssignments, this.correlation, this.originSubqueryError);
    }
}

