/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class TransformQuantifiedComparisonApplyToLateralJoin
implements PlanOptimizer {
    private final StandardFunctionResolution functionResolution;

    public TransformQuantifiedComparisonApplyToLateralJoin(FunctionManager functionManager) {
        Objects.requireNonNull(functionManager, "functionManager is null");
        this.functionResolution = new FunctionResolution(functionManager);
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(this.functionResolution, idAllocator, variableAllocator), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<PlanNode> {
        private final StandardFunctionResolution functionResolution;
        private final PlanNodeIdAllocator idAllocator;
        private final PlanVariableAllocator variableAllocator;

        public Rewriter(StandardFunctionResolution functionResolution, PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator) {
            this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            if (node.getSubqueryAssignments().size() != 1) {
                return context.defaultRewrite(node);
            }
            Expression expression = OriginalExpressionUtils.castToExpression((RowExpression)Iterables.getOnlyElement((Iterable)node.getSubqueryAssignments().getExpressions()));
            if (!(expression instanceof QuantifiedComparisonExpression)) {
                return context.defaultRewrite(node);
            }
            QuantifiedComparisonExpression quantifiedComparison = (QuantifiedComparisonExpression)expression;
            return this.rewriteQuantifiedApplyNode(node, quantifiedComparison, context);
        }

        private PlanNode rewriteQuantifiedApplyNode(ApplyNode node, QuantifiedComparisonExpression quantifiedComparison, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            PlanNode subqueryPlan = context.rewrite(node.getSubquery());
            VariableReferenceExpression outputColumn = (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)subqueryPlan.getOutputVariables());
            Type outputColumnType = outputColumn.getType();
            Preconditions.checkState((boolean)outputColumnType.isOrderable(), (Object)"Subquery result type must be orderable");
            VariableReferenceExpression minValue = this.variableAllocator.newVariable("min", outputColumnType);
            VariableReferenceExpression maxValue = this.variableAllocator.newVariable("max", outputColumnType);
            VariableReferenceExpression countAllValue = this.variableAllocator.newVariable("count_all", (Type)BigintType.BIGINT);
            VariableReferenceExpression countNonNullValue = this.variableAllocator.newVariable("count_non_null", (Type)BigintType.BIGINT);
            ImmutableList outputColumnReferences = ImmutableList.of((Object)OriginalExpressionUtils.castToRowExpression((Expression)this.toSymbolReference(outputColumn)));
            subqueryPlan = new AggregationNode(this.idAllocator.getNextId(), subqueryPlan, (Map)ImmutableMap.of((Object)minValue, (Object)new AggregationNode.Aggregation(new CallExpression("min", this.functionResolution.minFunction(outputColumnType), outputColumnType, (List)outputColumnReferences), Optional.empty(), Optional.empty(), false, Optional.empty()), (Object)maxValue, (Object)new AggregationNode.Aggregation(new CallExpression("max", this.functionResolution.maxFunction(outputColumnType), outputColumnType, (List)outputColumnReferences), Optional.empty(), Optional.empty(), false, Optional.empty()), (Object)countAllValue, (Object)new AggregationNode.Aggregation(new CallExpression("count", this.functionResolution.countFunction(), (Type)BigintType.BIGINT, Collections.emptyList()), Optional.empty(), Optional.empty(), false, Optional.empty()), (Object)countNonNullValue, (Object)new AggregationNode.Aggregation(new CallExpression("count", this.functionResolution.countFunction(outputColumnType), (Type)BigintType.BIGINT, (List)outputColumnReferences), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.globalAggregation(), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
            LateralJoinNode lateralJoinNode = new LateralJoinNode(node.getId(), context.rewrite(node.getInput()), subqueryPlan, node.getCorrelation(), LateralJoinNode.Type.INNER, node.getOriginSubqueryError());
            Expression valueComparedToSubquery = this.rewriteUsingBounds(quantifiedComparison, minValue, maxValue, countAllValue, countNonNullValue);
            VariableReferenceExpression quantifiedComparisonVariable = (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)node.getSubqueryAssignments().getVariables());
            return this.projectExpressions(lateralJoinNode, Assignments.of((VariableReferenceExpression)quantifiedComparisonVariable, (RowExpression)OriginalExpressionUtils.castToRowExpression(valueComparedToSubquery)));
        }

        public Expression rewriteUsingBounds(QuantifiedComparisonExpression quantifiedComparison, VariableReferenceExpression minValue, VariableReferenceExpression maxValue, VariableReferenceExpression countAllValue, VariableReferenceExpression countNonNullValue) {
            BooleanLiteral emptySetResult = quantifiedComparison.getQuantifier().equals((Object)QuantifiedComparisonExpression.Quantifier.ALL) ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL;
            Function<List, Expression> quantifier = quantifiedComparison.getQuantifier().equals((Object)QuantifiedComparisonExpression.Quantifier.ALL) ? ExpressionUtils::combineConjuncts : ExpressionUtils::combineDisjuncts;
            Expression comparisonWithExtremeValue = this.getBoundComparisons(quantifiedComparison, minValue, maxValue);
            return new SimpleCaseExpression((Expression)this.toSymbolReference(countAllValue), (List)ImmutableList.of((Object)new WhenClause((Expression)new GenericLiteral("bigint", "0"), (Expression)emptySetResult)), Optional.of(quantifier.apply((List)ImmutableList.of((Object)comparisonWithExtremeValue, (Object)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)this.toSymbolReference(countAllValue), (Expression)this.toSymbolReference(countNonNullValue)), (Expression)new Cast((Expression)new NullLiteral(), BooleanType.BOOLEAN.toString()))), Optional.of(emptySetResult))))));
        }

        private Expression getBoundComparisons(QuantifiedComparisonExpression quantifiedComparison, VariableReferenceExpression minValue, VariableReferenceExpression maxValue) {
            if (quantifiedComparison.getOperator() == ComparisonExpression.Operator.EQUAL && quantifiedComparison.getQuantifier() == QuantifiedComparisonExpression.Quantifier.ALL) {
                return ExpressionUtils.combineConjuncts(new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)this.toSymbolReference(minValue), (Expression)this.toSymbolReference(maxValue)), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, quantifiedComparison.getValue(), (Expression)this.toSymbolReference(maxValue))});
            }
            if (EnumSet.of(ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL).contains(quantifiedComparison.getOperator())) {
                VariableReferenceExpression boundValue = Rewriter.shouldCompareValueWithLowerBound(quantifiedComparison) ? minValue : maxValue;
                return new ComparisonExpression(quantifiedComparison.getOperator(), quantifiedComparison.getValue(), (Expression)this.toSymbolReference(boundValue));
            }
            throw new IllegalArgumentException("Unsupported quantified comparison: " + quantifiedComparison);
        }

        private static boolean shouldCompareValueWithLowerBound(QuantifiedComparisonExpression quantifiedComparison) {
            switch (quantifiedComparison.getQuantifier()) {
                case ALL: {
                    switch (quantifiedComparison.getOperator()) {
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            return true;
                        }
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: {
                            return false;
                        }
                    }
                    break;
                }
                case ANY: 
                case SOME: {
                    switch (quantifiedComparison.getOperator()) {
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            return false;
                        }
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: {
                            return true;
                        }
                    }
                }
            }
            throw new IllegalArgumentException("Unexpected quantifier: " + quantifiedComparison.getQuantifier());
        }

        private ProjectNode projectExpressions(PlanNode input, Assignments subqueryAssignments) {
            Assignments assignments = Assignments.builder().putAll(AssignmentUtils.identitiesAsSymbolReferences(input.getOutputVariables())).putAll(subqueryAssignments).build();
            return new ProjectNode(this.idAllocator.getNextId(), input, assignments);
        }

        private SymbolReference toSymbolReference(VariableReferenceExpression variable) {
            return new SymbolReference(variable.getName());
        }
    }
}

