/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Subfield;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PushdownSubfields
implements PlanOptimizer {
    private final Metadata metadata;

    public PushdownSubfields(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        if (!SystemSessionProperties.isPushdownSubfieldsEnabled(session)) {
            return plan;
        }
        return SimplePlanRewriter.rewriteWith(new Rewriter(session, this.metadata, types), plan, new Rewriter.Context());
    }

    private static class Rewriter
    extends SimplePlanRewriter<Context> {
        private final Session session;
        private final Metadata metadata;
        private final TypeProvider types;
        private final SubfieldExtractor subfieldExtractor;

        public Rewriter(Session session, Metadata metadata, TypeProvider types) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.subfieldExtractor = new SubfieldExtractor(types);
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getGroupingKeys());
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                aggregation.getArguments().forEach(expression -> {
                    Void cfr_ignored_0 = (Void)this.subfieldExtractor.process((Node)OriginalExpressionUtils.castToExpression(expression), context.get());
                });
                aggregation.getFilter().ifPresent(expression -> {
                    Void cfr_ignored_0 = (Void)this.subfieldExtractor.process((Node)OriginalExpressionUtils.castToExpression(expression), context.get());
                });
                aggregation.getOrderBy().map(OrderingScheme::getOrderByVariables).ifPresent(context.get().variables::addAll);
                aggregation.getMask().ifPresent(context.get().variables::add);
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getCorrelation());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getDistinctVariables());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getSource().getOutputVariables());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            this.subfieldExtractor.process((Node)OriginalExpressionUtils.castToExpression(node.getPredicate()), context.get());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            for (Map.Entry<VariableReferenceExpression, VariableReferenceExpression> entry : node.getGroupingColumns().entrySet()) {
                context.get().addAssignment(entry.getKey(), entry.getValue());
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getProbe).forEach(context.get().variables::add);
            node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).forEach(context.get().variables::add);
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            node.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).forEach(context.get().variables::add);
            node.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).forEach(context.get().variables::add);
            node.getFilter().map(OriginalExpressionUtils::castToExpression).ifPresent(expression -> {
                Void cfr_ignored_0 = (Void)this.subfieldExtractor.process((Node)expression, context.get());
            });
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getDistinctVariables());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getOutputVariables());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            for (Map.Entry entry : node.getAssignments().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                Expression expression = OriginalExpressionUtils.castToExpression((RowExpression)entry.getValue());
                if (expression instanceof SymbolReference) {
                    context.get().addAssignment(variable, new VariableReferenceExpression(((SymbolReference)expression).getName(), this.types.get(expression)));
                    continue;
                }
                Optional<Subfield> subfield = Rewriter.toSubfield((Node)expression);
                if (subfield.isPresent()) {
                    context.get().addAssignment(variable, subfield.get());
                    continue;
                }
                this.subfieldExtractor.process((Node)expression, context.get());
            }
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.add(node.getRowNumberVariable());
            context.get().variables.addAll(node.getPartitionBy());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.add(node.getSourceJoinVariable());
            context.get().variables.add(node.getFilteringSourceJoinVariable());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getOrderingScheme().getOrderByVariables());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSpatialJoin(SpatialJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            this.subfieldExtractor.process((Node)OriginalExpressionUtils.castToExpression(node.getFilter()), context.get());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            if (context.get().subfields.isEmpty()) {
                return node;
            }
            ImmutableMap.Builder newAssignments = ImmutableMap.builder();
            for (Map.Entry entry : node.getAssignments().entrySet()) {
                VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
                if (context.get().variables.contains(variable)) {
                    newAssignments.put(entry);
                    continue;
                }
                List subfields = context.get().findSubfields(variable.getName());
                Verify.verify((!subfields.isEmpty() ? 1 : 0) != 0, (String)("Missing variable: " + variable), (Object[])new Object[0]);
                String columnName = Rewriter.getColumnName(this.session, this.metadata, node.getTable(), (ColumnHandle)entry.getValue());
                List columnSubfields = (List)subfields.stream().filter(subfield -> !Rewriter.prefixExists(subfield, subfields)).map(Subfield::getPath).map(path -> new Subfield(columnName, path)).collect(ImmutableList.toImmutableList());
                newAssignments.put((Object)variable, (Object)((ColumnHandle)entry.getValue()).withRequiredSubfields(columnSubfields));
            }
            return new TableScanNode(node.getId(), node.getTable(), node.getOutputVariables(), (Map)newAssignments.build(), node.getCurrentConstraint(), node.getEnforcedConstraint());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getColumns());
            return context.defaultRewrite(node, context.get());
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getOrderingScheme().getOrderByVariables());
            return context.defaultRewrite((PlanNode)node, context.get());
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.add(node.getRowNumberVariable());
            context.get().variables.addAll(node.getPartitionBy());
            context.get().variables.addAll(node.getOrderingScheme().getOrderByVariables());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            for (Map.Entry entry : node.getVariableMapping().asMap().entrySet()) {
                ((Collection)entry.getValue()).forEach(variable -> ((Context)context.get()).addAssignment((VariableReferenceExpression)entry.getKey(), variable));
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            ImmutableList.Builder newSubfields = ImmutableList.builder();
            for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : node.getUnnestVariables().entrySet()) {
                List matchingSubfields;
                VariableReferenceExpression container = entry.getKey();
                boolean found = false;
                if (this.isRowType(container)) {
                    for (VariableReferenceExpression field : entry.getValue()) {
                        if (context.get().variables.contains(field)) {
                            found = true;
                            newSubfields.add((Object)new Subfield(container.getName(), (List)ImmutableList.of((Object)Subfield.allSubscripts(), (Object)new Subfield.NestedField(field.getName()))));
                            continue;
                        }
                        matchingSubfields = context.get().findSubfields(field.getName());
                        if (matchingSubfields.isEmpty()) continue;
                        found = true;
                        matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(container.getName(), (List)ImmutableList.builder().add((Object)Subfield.allSubscripts()).add((Object)new Subfield.NestedField(field.getName())).addAll((Iterable)path).build())).forEach(arg_0 -> ((ImmutableList.Builder)newSubfields).add(arg_0));
                    }
                } else {
                    for (VariableReferenceExpression field : entry.getValue()) {
                        if (context.get().variables.contains(field)) {
                            found = true;
                            context.get().variables.add(container);
                            continue;
                        }
                        matchingSubfields = context.get().findSubfields(field.getName());
                        if (matchingSubfields.isEmpty()) continue;
                        found = true;
                        matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(container.getName(), (List)ImmutableList.builder().add((Object)Subfield.allSubscripts()).addAll((Iterable)path).build())).forEach(arg_0 -> ((ImmutableList.Builder)newSubfields).add(arg_0));
                    }
                }
                if (found) continue;
                context.get().variables.add(container);
            }
            context.get().subfields.addAll(newSubfields.build());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().variables.addAll(node.getSpecification().getPartitionBy());
            node.getSpecification().getOrderingScheme().map(OrderingScheme::getOrderByVariables).ifPresent(context.get().variables::addAll);
            node.getWindowFunctions().values().stream().map(WindowNode.Function::getFunctionCall).map(CallExpression::getArguments).flatMap(Collection::stream).map(OriginalExpressionUtils::castToExpression).forEach(expression -> {
                Void cfr_ignored_0 = (Void)this.subfieldExtractor.process((Node)expression, context.get());
            });
            node.getWindowFunctions().values().stream().map(WindowNode.Function::getFrame).map(WindowNode.Frame::getStartValue).filter(Optional::isPresent).map(Optional::get).forEach(context.get().variables::add);
            node.getWindowFunctions().values().stream().map(WindowNode.Function::getFrame).map(WindowNode.Frame::getEndValue).filter(Optional::isPresent).map(Optional::get).forEach(context.get().variables::add);
            return context.defaultRewrite(node, context.get());
        }

        private boolean isRowType(VariableReferenceExpression variable) {
            return variable.getType() instanceof ArrayType && ((ArrayType)variable.getType()).getElementType() instanceof RowType;
        }

        private static boolean prefixExists(Subfield subfieldPath, Collection<Subfield> subfieldPaths) {
            return subfieldPaths.stream().anyMatch(path -> path.isPrefix(subfieldPath));
        }

        private static String getColumnName(Session session, Metadata metadata, TableHandle tableHandle, ColumnHandle columnHandle) {
            return metadata.getColumnMetadata(session, tableHandle, columnHandle).getName();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Optional<Subfield> toSubfield(Node expression) {
            ImmutableList.Builder elements = ImmutableList.builder();
            while (!(expression instanceof SymbolReference)) {
                if (expression instanceof DereferenceExpression) {
                    DereferenceExpression dereference = (DereferenceExpression)expression;
                    elements.add((Object)new Subfield.NestedField(dereference.getField().getValue()));
                    expression = dereference.getBase();
                    continue;
                }
                if (!(expression instanceof SubscriptExpression)) return Optional.empty();
                SubscriptExpression subscript = (SubscriptExpression)expression;
                Expression index = subscript.getIndex();
                if (index instanceof Cast) {
                    index = ((Cast)index).getExpression();
                }
                if (index instanceof LongLiteral) {
                    elements.add((Object)new Subfield.LongSubscript(((LongLiteral)index).getValue()));
                } else if (index instanceof StringLiteral) {
                    elements.add((Object)new Subfield.StringSubscript(((StringLiteral)index).getValue()));
                } else {
                    if (!(index instanceof GenericLiteral)) return Optional.empty();
                    GenericLiteral literal = (GenericLiteral)index;
                    if (!BigintType.BIGINT.getTypeSignature().equals((Object)TypeSignature.parseTypeSignature((String)literal.getType()))) return Optional.empty();
                    elements.add((Object)new Subfield.LongSubscript(Long.valueOf(literal.getValue()).longValue()));
                }
                expression = subscript.getBase();
            }
            return Optional.of(new Subfield(((SymbolReference)expression).getName(), (List)elements.build().reverse()));
        }

        private static final class Context {
            private final Set<VariableReferenceExpression> variables = new HashSet<VariableReferenceExpression>();
            private final Set<Subfield> subfields = new HashSet<Subfield>();

            private Context() {
            }

            private void addAssignment(VariableReferenceExpression variable, VariableReferenceExpression otherVariable) {
                if (this.variables.contains(variable)) {
                    this.variables.add(otherVariable);
                    return;
                }
                List<Subfield> matchingSubfields = this.findSubfields(variable.getName());
                Verify.verify((!matchingSubfields.isEmpty() ? 1 : 0) != 0, (String)("Missing variable: " + variable), (Object[])new Object[0]);
                matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(otherVariable.getName(), path)).forEach(this.subfields::add);
            }

            private void addAssignment(VariableReferenceExpression variable, Subfield subfield) {
                if (this.variables.contains(variable)) {
                    this.subfields.add(subfield);
                    return;
                }
                List<Subfield> matchingSubfields = this.findSubfields(variable.getName());
                Verify.verify((!matchingSubfields.isEmpty() ? 1 : 0) != 0, (String)("Missing variable: " + variable), (Object[])new Object[0]);
                matchingSubfields.stream().map(Subfield::getPath).map(path -> new Subfield(subfield.getRootName(), (List)ImmutableList.builder().addAll((Iterable)subfield.getPath()).addAll((Iterable)path).build())).forEach(this.subfields::add);
            }

            private List<Subfield> findSubfields(String rootName) {
                return (List)this.subfields.stream().filter(subfield -> rootName.equals(subfield.getRootName())).collect(ImmutableList.toImmutableList());
            }
        }

        private static final class SubfieldExtractor
        extends DefaultExpressionTraversalVisitor<Void, Context> {
            private final TypeProvider typeProvider;

            private SubfieldExtractor(TypeProvider typeProvider) {
                this.typeProvider = Objects.requireNonNull(typeProvider, "typeProvider is null");
            }

            protected Void visitSubscriptExpression(SubscriptExpression node, Context context) {
                Optional subfield = Rewriter.toSubfield((Node)node);
                if (subfield.isPresent()) {
                    context.subfields.add(subfield.get());
                } else {
                    this.process((Node)node.getBase(), context);
                    this.process((Node)node.getIndex(), context);
                }
                return null;
            }

            protected Void visitDereferenceExpression(DereferenceExpression node, Context context) {
                Optional subfield = Rewriter.toSubfield((Node)node);
                if (subfield.isPresent()) {
                    context.subfields.add(subfield.get());
                } else {
                    this.process((Node)node.getBase(), context);
                    this.process((Node)node.getField(), context);
                }
                return null;
            }

            protected Void visitSymbolReference(SymbolReference node, Context context) {
                context.variables.add(new VariableReferenceExpression(node.getName(), this.typeProvider.get((Expression)node)));
                return null;
            }
        }
    }
}

