/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ReorderJoins
implements Rule<JoinNode> {
    private static final Logger log = Logger.get(ReorderJoins.class);
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(joinNode -> !joinNode.getDistributionType().isPresent() && joinNode.getType() == JoinNode.Type.INNER && ExpressionDeterminismEvaluator.isDeterministic(joinNode.getFilter().map(OriginalExpressionUtils::castToExpression).orElse((Expression)BooleanLiteral.TRUE_LITERAL)));
    private final CostComparator costComparator;

    public ReorderJoins(CostComparator costComparator) {
        this.costComparator = Objects.requireNonNull(costComparator, "costComparator is null");
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.getJoinReorderingStrategy(session) == FeaturesConfig.JoinReorderingStrategy.AUTOMATIC;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        MultiJoinNode multiJoinNode = MultiJoinNode.toMultiJoinNode(joinNode, context.getLookup(), SystemSessionProperties.getMaxReorderedJoins(context.getSession()));
        JoinEnumerator joinEnumerator = new JoinEnumerator(this.costComparator, multiJoinNode.getFilter(), context);
        JoinEnumerationResult result = joinEnumerator.chooseJoinOrder(multiJoinNode.getSources(), multiJoinNode.getOutputVariables());
        if (!result.getPlanNode().isPresent()) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(result.getPlanNode().get());
    }

    @VisibleForTesting
    static class JoinEnumerationResult {
        public static final JoinEnumerationResult UNKNOWN_COST_RESULT = new JoinEnumerationResult(Optional.empty(), PlanCostEstimate.unknown());
        public static final JoinEnumerationResult INFINITE_COST_RESULT = new JoinEnumerationResult(Optional.empty(), PlanCostEstimate.infinite());
        private final Optional<PlanNode> planNode;
        private final PlanCostEstimate cost;

        private JoinEnumerationResult(Optional<PlanNode> planNode, PlanCostEstimate cost) {
            this.planNode = Objects.requireNonNull(planNode, "planNode is null");
            this.cost = Objects.requireNonNull(cost, "cost is null");
            Preconditions.checkArgument(((cost.hasUnknownComponents() || cost.equals(PlanCostEstimate.infinite())) && !planNode.isPresent() || (!cost.hasUnknownComponents() || !cost.equals(PlanCostEstimate.infinite())) && planNode.isPresent() ? 1 : 0) != 0, (Object)"planNode should be present if and only if cost is known");
        }

        public Optional<PlanNode> getPlanNode() {
            return this.planNode;
        }

        public PlanCostEstimate getCost() {
            return this.cost;
        }

        static JoinEnumerationResult createJoinEnumerationResult(Optional<PlanNode> planNode, PlanCostEstimate cost) {
            if (cost.hasUnknownComponents()) {
                return UNKNOWN_COST_RESULT;
            }
            if (cost.equals(PlanCostEstimate.infinite())) {
                return INFINITE_COST_RESULT;
            }
            return new JoinEnumerationResult(planNode, cost);
        }
    }

    @VisibleForTesting
    static class MultiJoinNode {
        private final LinkedHashSet<PlanNode> sources;
        private final Expression filter;
        private final List<VariableReferenceExpression> outputVariables;

        public MultiJoinNode(LinkedHashSet<PlanNode> sources, Expression filter, List<VariableReferenceExpression> outputVariables) {
            Objects.requireNonNull(sources, "sources is null");
            Preconditions.checkArgument((sources.size() > 1 ? 1 : 0) != 0, (Object)"sources size is <= 1");
            Objects.requireNonNull(filter, "filter is null");
            Objects.requireNonNull(outputVariables, "outputVariables is null");
            this.sources = sources;
            this.filter = filter;
            this.outputVariables = ImmutableList.copyOf(outputVariables);
            List inputVariables = (List)sources.stream().flatMap(source -> source.getOutputVariables().stream()).collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((boolean)inputVariables.containsAll(outputVariables), (Object)"inputs do not contain all output variables");
        }

        public Expression getFilter() {
            return this.filter;
        }

        public LinkedHashSet<PlanNode> getSources() {
            return this.sources;
        }

        public List<VariableReferenceExpression> getOutputVariables() {
            return this.outputVariables;
        }

        public static Builder builder() {
            return new Builder();
        }

        public int hashCode() {
            return Objects.hash(this.sources, ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(this.filter)), this.outputVariables);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultiJoinNode)) {
                return false;
            }
            MultiJoinNode other = (MultiJoinNode)obj;
            return this.sources.equals(other.sources) && ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(this.filter)).equals((Object)ImmutableSet.copyOf(ExpressionUtils.extractConjuncts(other.filter))) && this.outputVariables.equals(other.outputVariables);
        }

        static MultiJoinNode toMultiJoinNode(JoinNode joinNode, Lookup lookup, int joinLimit) {
            return new JoinNodeFlattener(joinNode, lookup, joinLimit + 1).toMultiJoinNode();
        }

        static class Builder {
            private List<PlanNode> sources;
            private Expression filter;
            private List<VariableReferenceExpression> outputVariables;

            Builder() {
            }

            public Builder setSources(PlanNode ... sources) {
                this.sources = ImmutableList.copyOf((Object[])sources);
                return this;
            }

            public Builder setFilter(Expression filter) {
                this.filter = filter;
                return this;
            }

            public Builder setOutputVariables(VariableReferenceExpression ... outputVariables) {
                this.outputVariables = ImmutableList.copyOf((Object[])outputVariables);
                return this;
            }

            public MultiJoinNode build() {
                return new MultiJoinNode(new LinkedHashSet<PlanNode>(this.sources), this.filter, this.outputVariables);
            }
        }

        private static class JoinNodeFlattener {
            private final LinkedHashSet<PlanNode> sources = new LinkedHashSet();
            private final List<Expression> filters = new ArrayList<Expression>();
            private final List<VariableReferenceExpression> outputVariables;
            private final Lookup lookup;

            JoinNodeFlattener(JoinNode node, Lookup lookup, int sourceLimit) {
                Objects.requireNonNull(node, "node is null");
                Preconditions.checkState((node.getType() == JoinNode.Type.INNER ? 1 : 0) != 0, (Object)"join type must be INNER");
                this.outputVariables = node.getOutputVariables();
                this.lookup = Objects.requireNonNull(lookup, "lookup is null");
                this.flattenNode(node, sourceLimit);
            }

            private void flattenNode(PlanNode node, int limit) {
                PlanNode resolved = this.lookup.resolve(node);
                if (!(resolved instanceof JoinNode) || this.sources.size() > limit - 2) {
                    this.sources.add(node);
                    return;
                }
                JoinNode joinNode = (JoinNode)resolved;
                if (joinNode.getType() != JoinNode.Type.INNER || !ExpressionDeterminismEvaluator.isDeterministic(joinNode.getFilter().map(OriginalExpressionUtils::castToExpression).orElse((Expression)BooleanLiteral.TRUE_LITERAL)) || joinNode.getDistributionType().isPresent()) {
                    this.sources.add(node);
                    return;
                }
                this.flattenNode(joinNode.getLeft(), limit - 1);
                this.flattenNode(joinNode.getRight(), limit);
                joinNode.getCriteria().stream().map(JoinNodeUtils::toExpression).forEach(this.filters::add);
                joinNode.getFilter().ifPresent(filter -> this.filters.add(OriginalExpressionUtils.castToExpression(filter)));
            }

            MultiJoinNode toMultiJoinNode() {
                return new MultiJoinNode(this.sources, ExpressionUtils.and(this.filters), this.outputVariables);
            }
        }
    }

    @VisibleForTesting
    static class JoinEnumerator {
        private final Session session;
        private final CostProvider costProvider;
        private final Ordering<JoinEnumerationResult> resultComparator;
        private final PlanNodeIdAllocator idAllocator;
        private final Expression allFilter;
        private final EqualityInference allFilterInference;
        private final Lookup lookup;
        private final Rule.Context context;
        private final Map<Set<PlanNode>, JoinEnumerationResult> memo = new HashMap<Set<PlanNode>, JoinEnumerationResult>();

        @VisibleForTesting
        JoinEnumerator(CostComparator costComparator, Expression filter, Rule.Context context) {
            this.context = Objects.requireNonNull(context);
            this.session = Objects.requireNonNull(context.getSession(), "session is null");
            this.costProvider = Objects.requireNonNull(context.getCostProvider(), "costProvider is null");
            this.resultComparator = costComparator.forSession(this.session).onResultOf(result -> ((JoinEnumerationResult)result).cost);
            this.idAllocator = Objects.requireNonNull(context.getIdAllocator(), "idAllocator is null");
            this.allFilter = Objects.requireNonNull(filter, "filter is null");
            this.allFilterInference = EqualityInference.createEqualityInference(filter);
            this.lookup = Objects.requireNonNull(context.getLookup(), "lookup is null");
        }

        private JoinEnumerationResult chooseJoinOrder(LinkedHashSet<PlanNode> sources, List<VariableReferenceExpression> outputVariables) {
            this.context.checkTimeoutNotExhausted();
            ImmutableSet multiJoinKey = ImmutableSet.copyOf(sources);
            JoinEnumerationResult bestResult = this.memo.get(multiJoinKey);
            if (bestResult == null) {
                Preconditions.checkState((sources.size() > 1 ? 1 : 0) != 0, (Object)"sources size is less than or equal to one");
                ImmutableList.Builder resultBuilder = ImmutableList.builder();
                Set<Set<Integer>> partitions = JoinEnumerator.generatePartitions(sources.size());
                for (Set<Integer> partition : partitions) {
                    JoinEnumerationResult result = this.createJoinAccordingToPartitioning(sources, outputVariables, partition);
                    if (result.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                        this.memo.put((Set<PlanNode>)multiJoinKey, result);
                        return result;
                    }
                    if (result.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) continue;
                    resultBuilder.add((Object)result);
                }
                ImmutableList results = resultBuilder.build();
                if (results.isEmpty()) {
                    this.memo.put((Set<PlanNode>)multiJoinKey, JoinEnumerationResult.INFINITE_COST_RESULT);
                    return JoinEnumerationResult.INFINITE_COST_RESULT;
                }
                bestResult = (JoinEnumerationResult)this.resultComparator.min((Iterable)results);
                this.memo.put((Set<PlanNode>)multiJoinKey, bestResult);
            }
            bestResult.planNode.ifPresent(planNode -> log.debug("Least cost join was: %s", new Object[]{planNode}));
            return bestResult;
        }

        @VisibleForTesting
        static Set<Set<Integer>> generatePartitions(int totalNodes) {
            Preconditions.checkArgument((totalNodes > 1 ? 1 : 0) != 0, (Object)"totalNodes must be greater than 1");
            Set numbers = (Set)IntStream.range(0, totalNodes).boxed().collect(ImmutableSet.toImmutableSet());
            return (Set)Sets.powerSet((Set)numbers).stream().filter(subSet -> subSet.contains(0)).filter(subSet -> subSet.size() < numbers.size()).collect(ImmutableSet.toImmutableSet());
        }

        @VisibleForTesting
        JoinEnumerationResult createJoinAccordingToPartitioning(LinkedHashSet<PlanNode> sources, List<VariableReferenceExpression> outputVariables, Set<Integer> partitioning) {
            ImmutableList sourceList = ImmutableList.copyOf(sources);
            LinkedHashSet leftSources = partitioning.stream().map(((List)sourceList)::get).collect(Collectors.toCollection(LinkedHashSet::new));
            LinkedHashSet rightSources = sources.stream().filter(source -> !leftSources.contains(source)).collect(Collectors.toCollection(LinkedHashSet::new));
            return this.createJoin(leftSources, rightSources, outputVariables);
        }

        private JoinEnumerationResult createJoin(LinkedHashSet<PlanNode> leftSources, LinkedHashSet<PlanNode> rightSources, List<VariableReferenceExpression> outputVariables) {
            Set rightVariables;
            Set leftVariables = (Set)leftSources.stream().flatMap(node -> node.getOutputVariables().stream()).collect(ImmutableSet.toImmutableSet());
            List<Expression> joinPredicates = this.getJoinPredicates(leftVariables, rightVariables = (Set)rightSources.stream().flatMap(node -> node.getOutputVariables().stream()).collect(ImmutableSet.toImmutableSet()));
            List joinConditions = (List)joinPredicates.stream().filter(JoinEnumerator::isJoinEqualityCondition).map(predicate -> JoinEnumerator.toEquiJoinClause((ComparisonExpression)predicate, leftVariables, this.context.getVariableAllocator())).collect(ImmutableList.toImmutableList());
            if (joinConditions.isEmpty()) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            List joinFilters = (List)joinPredicates.stream().filter(predicate -> !JoinEnumerator.isJoinEqualityCondition(predicate)).collect(ImmutableList.toImmutableList());
            ImmutableSet requiredJoinVariables = ImmutableSet.builder().addAll(outputVariables).addAll(VariablesExtractor.extractUnique(joinPredicates, this.context.getVariableAllocator().getTypes())).build();
            JoinEnumerationResult leftResult = this.getJoinSource(leftSources, (List)requiredJoinVariables.stream().filter(leftVariables::contains).collect(ImmutableList.toImmutableList()));
            if (leftResult.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            if (leftResult.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            PlanNode left = (PlanNode)leftResult.planNode.orElseThrow(() -> new VerifyException("Plan node is not present"));
            JoinEnumerationResult rightResult = this.getJoinSource(rightSources, (List)requiredJoinVariables.stream().filter(rightVariables::contains).collect(ImmutableList.toImmutableList()));
            if (rightResult.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            if (rightResult.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            PlanNode right = (PlanNode)rightResult.planNode.orElseThrow(() -> new VerifyException("Plan node is not present"));
            List sortedOutputVariables = (List)Stream.concat(left.getOutputVariables().stream(), right.getOutputVariables().stream()).filter(outputVariables::contains).collect(ImmutableList.toImmutableList());
            return this.setJoinNodeProperties(new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.INNER, left, right, joinConditions, sortedOutputVariables, joinFilters.isEmpty() ? Optional.empty() : Optional.of(OriginalExpressionUtils.castToRowExpression(ExpressionUtils.and(joinFilters))), Optional.empty(), Optional.empty(), Optional.empty()));
        }

        private List<Expression> getJoinPredicates(Set<VariableReferenceExpression> leftVariables, Set<VariableReferenceExpression> rightVariables) {
            ImmutableList.Builder joinPredicatesBuilder = ImmutableList.builder();
            Streams.stream(EqualityInference.nonInferrableConjuncts(this.allFilter)).map(conjunct -> this.allFilterInference.rewriteExpression((Expression)conjunct, (Predicate<VariableReferenceExpression>)((Predicate)variable -> leftVariables.contains(variable) || rightVariables.contains(variable)), this.context.getVariableAllocator().getTypes())).filter(Objects::nonNull).filter(conjunct -> this.allFilterInference.rewriteExpression((Expression)conjunct, (Predicate<VariableReferenceExpression>)((Predicate)leftVariables::contains), this.context.getVariableAllocator().getTypes()) == null).filter(conjunct -> this.allFilterInference.rewriteExpression((Expression)conjunct, (Predicate<VariableReferenceExpression>)((Predicate)rightVariables::contains), this.context.getVariableAllocator().getTypes()) == null).forEach(arg_0 -> ((ImmutableList.Builder)joinPredicatesBuilder).add(arg_0));
            List<Expression> joinEqualities = this.allFilterInference.generateEqualitiesPartitionedBy((Predicate<VariableReferenceExpression>)((Predicate)variable -> leftVariables.contains(variable) || rightVariables.contains(variable)), this.context.getVariableAllocator().getTypes()).getScopeEqualities();
            EqualityInference joinInference = EqualityInference.createEqualityInference(joinEqualities.toArray(new Expression[0]));
            joinPredicatesBuilder.addAll(joinInference.generateEqualitiesPartitionedBy((Predicate<VariableReferenceExpression>)Predicates.in(leftVariables), this.context.getVariableAllocator().getTypes()).getScopeStraddlingEqualities());
            return joinPredicatesBuilder.build();
        }

        private JoinEnumerationResult getJoinSource(LinkedHashSet<PlanNode> nodes, List<VariableReferenceExpression> outputVariables) {
            if (nodes.size() == 1) {
                PlanNode planNode = (PlanNode)Iterables.getOnlyElement(nodes);
                ImmutableList.Builder predicates = ImmutableList.builder();
                predicates.addAll(this.allFilterInference.generateEqualitiesPartitionedBy((Predicate<VariableReferenceExpression>)((Predicate)outputVariables::contains), this.context.getVariableAllocator().getTypes()).getScopeEqualities());
                Streams.stream(EqualityInference.nonInferrableConjuncts(this.allFilter)).map(conjunct -> this.allFilterInference.rewriteExpression((Expression)conjunct, (Predicate<VariableReferenceExpression>)((Predicate)outputVariables::contains), this.context.getVariableAllocator().getTypes())).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)predicates).add(arg_0));
                Expression filter = ExpressionUtils.combineConjuncts((Collection<Expression>)predicates.build());
                if (!BooleanLiteral.TRUE_LITERAL.equals((Object)filter)) {
                    planNode = new FilterNode(this.idAllocator.getNextId(), planNode, OriginalExpressionUtils.castToRowExpression(filter));
                }
                return this.createJoinEnumerationResult(planNode);
            }
            return this.chooseJoinOrder(nodes, outputVariables);
        }

        private static boolean isJoinEqualityCondition(Expression expression) {
            return expression instanceof ComparisonExpression && ((ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL && ((ComparisonExpression)expression).getLeft() instanceof SymbolReference && ((ComparisonExpression)expression).getRight() instanceof SymbolReference;
        }

        private static JoinNode.EquiJoinClause toEquiJoinClause(ComparisonExpression equality, Set<VariableReferenceExpression> leftVariables, PlanVariableAllocator variableAllocator) {
            VariableReferenceExpression leftVariable = variableAllocator.toVariableReference(equality.getLeft());
            VariableReferenceExpression rightVariable = variableAllocator.toVariableReference(equality.getRight());
            JoinNode.EquiJoinClause equiJoinClause = new JoinNode.EquiJoinClause(leftVariable, rightVariable);
            return leftVariables.contains(leftVariable) ? equiJoinClause : equiJoinClause.flip();
        }

        private JoinEnumerationResult setJoinNodeProperties(JoinNode joinNode) {
            if (QueryCardinalityUtil.isAtMostScalar(joinNode.getRight(), this.lookup)) {
                return this.createJoinEnumerationResult(joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED));
            }
            if (QueryCardinalityUtil.isAtMostScalar(joinNode.getLeft(), this.lookup)) {
                return this.createJoinEnumerationResult(joinNode.flipChildren().withDistributionType(JoinNode.DistributionType.REPLICATED));
            }
            List<JoinEnumerationResult> possibleJoinNodes = this.getPossibleJoinNodes(joinNode, SystemSessionProperties.getJoinDistributionType(this.session));
            Verify.verify((!possibleJoinNodes.isEmpty() ? 1 : 0) != 0, (String)"possibleJoinNodes is empty", (Object[])new Object[0]);
            if (possibleJoinNodes.stream().anyMatch(JoinEnumerationResult.UNKNOWN_COST_RESULT::equals)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            return (JoinEnumerationResult)this.resultComparator.min(possibleJoinNodes);
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, FeaturesConfig.JoinDistributionType distributionType) {
            Preconditions.checkArgument((joinNode.getType() == JoinNode.Type.INNER ? 1 : 0) != 0, (String)"unexpected join node type: %s", (Object)((Object)joinNode.getType()));
            if (joinNode.isCrossJoin()) {
                return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED);
            }
            switch (distributionType) {
                case PARTITIONED: {
                    return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.PARTITIONED);
                }
                case BROADCAST: {
                    return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED);
                }
                case AUTOMATIC: {
                    ImmutableList.Builder result = ImmutableList.builder();
                    result.addAll(this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.PARTITIONED));
                    if (DetermineJoinDistributionType.isBelowMaxBroadcastSize(joinNode, this.context)) {
                        result.addAll(this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED));
                    }
                    return result.build();
                }
            }
            throw new IllegalArgumentException("unexpected join distribution type: " + (Object)((Object)distributionType));
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, JoinNode.DistributionType distributionType) {
            return ImmutableList.of((Object)this.createJoinEnumerationResult(joinNode.withDistributionType(distributionType)), (Object)this.createJoinEnumerationResult(joinNode.flipChildren().withDistributionType(distributionType)));
        }

        private JoinEnumerationResult createJoinEnumerationResult(PlanNode planNode) {
            return JoinEnumerationResult.createJoinEnumerationResult(Optional.of(planNode), this.costProvider.getCost(planNode));
        }
    }
}

