/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneIndexSourceColumns
extends ProjectOffPushDownRule<IndexSourceNode> {
    public PruneIndexSourceColumns() {
        super(Patterns.indexSource());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator, IndexSourceNode indexSourceNode, Set<VariableReferenceExpression> referencedOutputs) {
        Set prunedLookupSymbols = (Set)indexSourceNode.getLookupVariables().stream().filter(referencedOutputs::contains).collect(ImmutableSet.toImmutableSet());
        Map prunedAssignments = Maps.filterEntries(indexSourceNode.getAssignments(), entry -> referencedOutputs.contains(entry.getKey()) || PruneIndexSourceColumns.tupleDomainReferencesColumnHandle(indexSourceNode.getCurrentConstraint(), (ColumnHandle)entry.getValue()));
        List prunedOutputList = (List)indexSourceNode.getOutputVariables().stream().filter(referencedOutputs::contains).collect(ImmutableList.toImmutableList());
        return Optional.of(new IndexSourceNode(indexSourceNode.getId(), indexSourceNode.getIndexHandle(), indexSourceNode.getTableHandle(), prunedLookupSymbols, prunedOutputList, prunedAssignments, indexSourceNode.getCurrentConstraint()));
    }

    private static boolean tupleDomainReferencesColumnHandle(TupleDomain<ColumnHandle> tupleDomain, ColumnHandle columnHandle) {
        return tupleDomain.getDomains().map(domains -> domains.containsKey(columnHandle)).orElse(false);
    }
}

