/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneAggregationColumns
extends ProjectOffPushDownRule<AggregationNode> {
    public PruneAggregationColumns() {
        super(Patterns.aggregation());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, PlanVariableAllocator variableAllocator, AggregationNode aggregationNode, Set<VariableReferenceExpression> referencedOutputs) {
        Map prunedAggregations = Maps.filterKeys((Map)aggregationNode.getAggregations(), referencedOutputs::contains);
        if (prunedAggregations.size() == aggregationNode.getAggregations().size()) {
            return Optional.empty();
        }
        return Optional.of(new AggregationNode(aggregationNode.getId(), aggregationNode.getSource(), prunedAggregations, aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedVariables(), aggregationNode.getStep(), aggregationNode.getHashVariable(), aggregationNode.getGroupIdVariable()));
    }
}

