/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TryExpression;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NullabilityAnalyzer {
    private NullabilityAnalyzer() {
    }

    public static boolean mayReturnNullOnNonNullInput(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean result = new AtomicBoolean(false);
        new Visitor().process((Node)expression, result);
        return result.get();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Void, AtomicBoolean> {
        private Visitor() {
        }

        protected Void visitCast(Cast node, AtomicBoolean result) {
            result.set(node.isSafe() || !node.isTypeOnly());
            return null;
        }

        protected Void visitNullIfExpression(NullIfExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitInPredicate(InPredicate node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSearchedCaseExpression(SearchedCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSimpleCaseExpression(SimpleCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSubscriptExpression(SubscriptExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitTryExpression(TryExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitIfExpression(IfExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean result) {
            result.set(true);
            return null;
        }
    }
}

