/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class LookupSymbolResolver
implements SymbolResolver {
    private final Map<Symbol, ColumnHandle> assignments;
    private final Map<ColumnHandle, NullableValue> bindings;

    public LookupSymbolResolver(Map<VariableReferenceExpression, ColumnHandle> assignments, Map<ColumnHandle, NullableValue> bindings) {
        Objects.requireNonNull(assignments, "assignments is null");
        Objects.requireNonNull(bindings, "bindings is null");
        this.assignments = (Map)assignments.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new Symbol(((VariableReferenceExpression)entry.getKey()).getName()), Map.Entry::getValue));
        this.bindings = ImmutableMap.copyOf(bindings);
    }

    @Override
    public Object getValue(Symbol symbol) {
        ColumnHandle column = this.assignments.get(symbol);
        Preconditions.checkArgument((column != null ? 1 : 0) != 0, (String)"Missing column assignment for %s", (Object)symbol);
        if (!this.bindings.containsKey(column)) {
            return symbol.toSymbolReference();
        }
        return this.bindings.get(column).getValue();
    }
}

