/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.scalar.VarbinaryFunctions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlVarbinary;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.InterpretedFunctionInvoker;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.SqlIntervalDayTime;
import com.facebook.presto.type.SqlIntervalYearMonth;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.List;

public final class LiteralInterpreter {
    private LiteralInterpreter() {
    }

    public static Object evaluate(Metadata metadata, ConnectorSession session, Expression node) {
        if (!(node instanceof Literal)) {
            throw new IllegalArgumentException("node must be a Literal");
        }
        return new LiteralVisitor(metadata).process((Node)node, session);
    }

    public static Object evaluate(ConnectorSession session, ConstantExpression node) {
        Type type = node.getType();
        if (node.getValue() == null) {
            return null;
        }
        if (type instanceof BooleanType) {
            return node.getValue();
        }
        if (type instanceof BigintType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType) {
            return node.getValue();
        }
        if (type instanceof DoubleType) {
            return node.getValue();
        }
        if (type instanceof RealType) {
            Long number = (Long)node.getValue();
            return Float.valueOf(Float.intBitsToFloat(number.intValue()));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                Preconditions.checkState((boolean)(node.getValue() instanceof Long));
                return LiteralInterpreter.decodeDecimal(BigInteger.valueOf((Long)node.getValue()), decimalType);
            }
            Preconditions.checkState((boolean)(node.getValue() instanceof Slice));
            Slice value = (Slice)node.getValue();
            return LiteralInterpreter.decodeDecimal(Decimals.decodeUnscaledValue((Slice)value), decimalType);
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return ((Slice)node.getValue()).toStringUtf8();
        }
        if (type instanceof VarbinaryType) {
            return new SqlVarbinary(((Slice)node.getValue()).getBytes());
        }
        if (type instanceof DateType) {
            return new SqlDate(((Long)node.getValue()).intValue());
        }
        if (type instanceof TimeType) {
            if (session.isLegacyTimestamp()) {
                return new SqlTime(((Long)node.getValue()).longValue(), session.getTimeZoneKey());
            }
            return new SqlTime(((Long)node.getValue()).longValue());
        }
        if (type instanceof TimestampType) {
            try {
                if (session.isLegacyTimestamp()) {
                    return new SqlTimestamp(((Long)node.getValue()).longValue(), session.getTimeZoneKey());
                }
                return new SqlTimestamp(((Long)node.getValue()).longValue());
            }
            catch (RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("'%s' is not a valid timestamp literal", (String)node.getValue()));
            }
        }
        if (type instanceof IntervalDayTimeType) {
            return new SqlIntervalDayTime((Long)node.getValue());
        }
        if (type instanceof IntervalYearMonthType) {
            return new SqlIntervalYearMonth(((Long)node.getValue()).intValue());
        }
        if (type.getJavaType().equals(Slice.class)) {
            return "'" + VarbinaryFunctions.toBase64((Slice)node.getValue()).toStringUtf8() + "'";
        }
        return node.getValue();
    }

    private static Number decodeDecimal(BigInteger unscaledValue, DecimalType type) {
        return new BigDecimal(unscaledValue, type.getScale(), new MathContext(type.getPrecision()));
    }

    private static class LiteralVisitor
    extends AstVisitor<Object, ConnectorSession> {
        private final Metadata metadata;
        private final InterpretedFunctionInvoker functionInvoker;

        private LiteralVisitor(Metadata metadata) {
            this.metadata = metadata;
            this.functionInvoker = new InterpretedFunctionInvoker(metadata.getFunctionManager());
        }

        protected Object visitLiteral(Literal node, ConnectorSession session) {
            throw new UnsupportedOperationException("Unhandled literal type: " + node);
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Long visitLongLiteral(LongLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Double visitDoubleLiteral(DoubleLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Object visitDecimalLiteral(DecimalLiteral node, ConnectorSession context) {
            return Decimals.parse((String)node.getValue()).getObject();
        }

        protected Slice visitStringLiteral(StringLiteral node, ConnectorSession session) {
            return node.getSlice();
        }

        protected Object visitCharLiteral(CharLiteral node, ConnectorSession context) {
            return node.getSlice();
        }

        protected Slice visitBinaryLiteral(BinaryLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Object visitGenericLiteral(GenericLiteral node, ConnectorSession session) {
            Type type = this.metadata.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            if (JsonType.JSON.equals(type)) {
                FunctionHandle functionHandle = this.metadata.getFunctionManager().lookupFunction("json_parse", TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR}));
                return this.functionInvoker.invoke(functionHandle, session, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            try {
                FunctionHandle functionHandle = this.metadata.getFunctionManager().lookupCast(CastType.CAST, VarcharType.VARCHAR.getTypeSignature(), type.getTypeSignature());
                return this.functionInvoker.invoke(functionHandle, session, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "No literal form for type %s", type);
            }
        }

        protected Long visitTimeLiteral(TimeLiteral node, ConnectorSession session) {
            if (session.isLegacyTimestamp()) {
                return DateTimeUtils.parseTimeLiteral(session.getTimeZoneKey(), node.getValue());
            }
            return DateTimeUtils.parseTimeLiteral(node.getValue());
        }

        protected Long visitTimestampLiteral(TimestampLiteral node, ConnectorSession session) {
            try {
                if (session.isLegacyTimestamp()) {
                    return DateTimeUtils.parseTimestampLiteral(session.getTimeZoneKey(), node.getValue());
                }
                return DateTimeUtils.parseTimestampLiteral(node.getValue());
            }
            catch (RuntimeException e) {
                throw new SemanticException(SemanticErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid timestamp literal", node.getValue());
            }
        }

        protected Long visitIntervalLiteral(IntervalLiteral node, ConnectorSession session) {
            if (node.isYearToMonth()) {
                return (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField());
            }
            return (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
        }

        protected Object visitNullLiteral(NullLiteral node, ConnectorSession session) {
            return null;
        }
    }
}

