/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import java.util.Map;
import java.util.Set;

public class Coercer {
    private Coercer() {
    }

    public static Expression addCoercions(Expression expression, Analysis analysis) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Rewriter(analysis.getCoercions(), analysis.getTypeOnlyCoercions()), (Expression)expression);
    }

    public static Expression addCoercions(Expression expression, Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Rewriter(coercions, typeOnlyCoercions), (Expression)expression);
    }

    private static class Rewriter
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> coercions;
        private final Set<NodeRef<Expression>> typeOnlyCoercions;

        public Rewriter(Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions) {
            this.coercions = coercions;
            this.typeOnlyCoercions = typeOnlyCoercions;
        }

        public Expression rewriteExpression(Expression expression, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Type target = this.coercions.get(NodeRef.of((Node)expression));
            Expression rewritten = treeRewriter.defaultRewrite(expression, null);
            if (target != null) {
                rewritten = new Cast(rewritten, target.getTypeSignature().toString(), false, this.typeOnlyCoercions.contains(NodeRef.of((Node)expression)));
            }
            return rewritten;
        }
    }
}

