/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FunctionCallCodeGenerator {
    public BytecodeNode generateCall(FunctionHandle functionHandle, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        FunctionManager functionManager = context.getFunctionManager();
        ScalarFunctionImplementation function = functionManager.getScalarFunctionImplementation(functionHandle);
        ArrayList<BytecodeNode> argumentsBytecode = new ArrayList<BytecodeNode>();
        for (int i = 0; i < arguments.size(); ++i) {
            RowExpression argument = arguments.get(i);
            ScalarFunctionImplementation.ArgumentProperty argumentProperty = function.getArgumentProperty(i);
            if (argumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.VALUE_TYPE) {
                argumentsBytecode.add(context.generate(argument, Optional.empty()));
                continue;
            }
            argumentsBytecode.add(context.generate(argument, Optional.empty(), Optional.of(argumentProperty.getLambdaInterface())));
        }
        return context.generateCall(functionManager.getFunctionMetadata(functionHandle).getName().getSuffix(), function, argumentsBytecode, outputBlockVariable.map(variable -> new BytecodeUtils.OutputBlockVariableAndType((Variable)variable, returnType)));
    }
}

