/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.smile;

import com.facebook.presto.server.smile.Codec;
import com.facebook.presto.server.smile.SmileObjectMapperProvider;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.Beta;
import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

@Beta
public class SmileCodec<T>
implements Codec<T> {
    private static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = Suppliers.memoize(() -> new SmileObjectMapperProvider().get());
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    public static <T> SmileCodec<T> smileCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new SmileCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    public static <T> SmileCodec<T> smileCodec(TypeToken<T> type) {
        Objects.requireNonNull(type, "type is null");
        return new SmileCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type.getType());
    }

    public static <T> SmileCodec<List<T>> listSmileCodec(Class<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type).getType();
        return new SmileCodec<List<T>>(OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <T> SmileCodec<List<T>> listSmileCodec(SmileCodec<T> type) {
        Objects.requireNonNull(type, "type is null");
        Type listType = new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type.getTypeToken()).getType();
        return new SmileCodec<List<T>>(OBJECT_MAPPER_SUPPLIER.get(), listType);
    }

    public static <K, V> SmileCodec<Map<K, V>> mapSmileCodec(Class<K> keyType, Class<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
        return new SmileCodec<Map<K, V>>(OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    public static <K, V> SmileCodec<Map<K, V>> mapSmileCodec(Class<K> keyType, SmileCodec<V> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        Type mapType = new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType.getTypeToken()).getType();
        return new SmileCodec<Map<K, V>>(OBJECT_MAPPER_SUPPLIER.get(), mapType);
    }

    SmileCodec(ObjectMapper mapper, Type type) {
        this.mapper = mapper;
        this.type = type;
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public Type getType() {
        return this.type;
    }

    public T fromSmile(byte[] bytes) throws IllegalArgumentException {
        try {
            return (T)this.mapper.readValue(bytes, this.javaType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Invalid SMILE bytes for %s", this.javaType), e);
        }
    }

    @Override
    public byte[] toBytes(T instance) throws IllegalArgumentException {
        try {
            return this.mapper.writeValueAsBytes(instance);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to SMILE", instance.getClass().getName()), e);
        }
    }

    TypeToken<T> getTypeToken() {
        return TypeToken.of((Type)this.type);
    }
}

