/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.presto.client.QueryResults;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.server.ForStatementResource;
import com.facebook.presto.server.HttpRequestSessionContext;
import com.facebook.presto.server.protocol.PurgeQueriesRunnable;
import com.facebook.presto.server.protocol.Query;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.security.SelectedRole;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.http.server.AsyncResponseHandler;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Path(value="/v1/statement")
public class StatementResource {
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private static final DataSize DEFAULT_TARGET_RESULT_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private static final DataSize MAX_TARGET_RESULT_SIZE = new DataSize(128.0, DataSize.Unit.MEGABYTE);
    private final QueryManager queryManager;
    private final SessionPropertyManager sessionPropertyManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final BlockEncodingSerde blockEncodingSerde;
    private final BoundedExecutor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final ConcurrentMap<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"query-purger"));
    private final CounterStat createQueryRequests = new CounterStat();

    @Inject
    public StatementResource(QueryManager queryManager, SessionPropertyManager sessionPropertyManager, ExchangeClientSupplier exchangeClientSupplier, BlockEncodingSerde blockEncodingSerde, @ForStatementResource BoundedExecutor responseExecutor, @ForStatementResource ScheduledExecutorService timeoutExecutor) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.exchangeClientSupplier = Objects.requireNonNull(exchangeClientSupplier, "exchangeClientSupplier is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.responseExecutor = Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.queryPurger.scheduleWithFixedDelay(new PurgeQueriesRunnable(this.queries, queryManager), 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    @POST
    @Produces(value={"application/json"})
    public Response createQuery(String statement, @HeaderParam(value="X-Forwarded-Proto") String proto, @Context HttpServletRequest servletRequest, @Context UriInfo uriInfo) {
        this.createQueryRequests.update(1L);
        if (Strings.isNullOrEmpty((String)statement)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"SQL statement is empty").build());
        }
        if (Strings.isNullOrEmpty((String)proto)) {
            proto = uriInfo.getRequestUri().getScheme();
        }
        HttpRequestSessionContext sessionContext = new HttpRequestSessionContext(servletRequest);
        ExchangeClient exchangeClient = this.exchangeClientSupplier.get((LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), StatementResource.class.getSimpleName()));
        Query query = Query.create(sessionContext, statement, this.queryManager, this.sessionPropertyManager, exchangeClient, (Executor)this.responseExecutor, this.timeoutExecutor, this.blockEncodingSerde);
        this.queries.put(query.getQueryId(), query);
        QueryResults queryResults = query.getNextResult(OptionalLong.empty(), uriInfo, proto, DEFAULT_TARGET_RESULT_SIZE);
        return StatementResource.toResponse(query, queryResults);
    }

    @GET
    @Path(value="{queryId}/{token}")
    @Produces(value={"application/json"})
    public void getQueryResults(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug, @QueryParam(value="maxWait") Duration maxWait, @QueryParam(value="targetResultSize") DataSize targetResultSize, @HeaderParam(value="X-Forwarded-Proto") String proto, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        Query query = this.getQuery(queryId, slug);
        if (query == null) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return;
        }
        if (Strings.isNullOrEmpty((String)proto)) {
            proto = uriInfo.getRequestUri().getScheme();
        }
        this.asyncQueryResults(query, OptionalLong.of(token), maxWait, targetResultSize, uriInfo, proto, asyncResponse);
    }

    @Nullable
    private Query getQuery(QueryId queryId, String slug) {
        Query query = (Query)this.queries.get(queryId);
        if (query != null && query.isSlugValid(slug)) {
            return query;
        }
        return null;
    }

    private void asyncQueryResults(Query query, OptionalLong token, Duration maxWait, DataSize targetResultSize, UriInfo uriInfo, String scheme, AsyncResponse asyncResponse) {
        Duration wait = (Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait);
        targetResultSize = targetResultSize == null ? DEFAULT_TARGET_RESULT_SIZE : (DataSize)Ordering.natural().min((Object)targetResultSize, (Object)MAX_TARGET_RESULT_SIZE);
        ListenableFuture<QueryResults> queryResultsFuture = query.waitForResults(token, uriInfo, scheme, wait, targetResultSize);
        ListenableFuture response = Futures.transform(queryResultsFuture, queryResults -> StatementResource.toResponse(query, queryResults), (Executor)MoreExecutors.directExecutor());
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)response, (Executor)this.responseExecutor);
    }

    private static Response toResponse(Query query, QueryResults queryResults) {
        Response.ResponseBuilder response = Response.ok((Object)queryResults);
        query.getSetCatalog().ifPresent(catalog -> response.header("X-Presto-Set-Catalog", catalog));
        query.getSetSchema().ifPresent(schema -> response.header("X-Presto-Set-Schema", schema));
        query.getSetSessionProperties().entrySet().forEach(entry -> response.header("X-Presto-Set-Session", (Object)((String)entry.getKey() + '=' + (String)entry.getValue())));
        query.getResetSessionProperties().forEach(name -> response.header("X-Presto-Clear-Session", name));
        query.getSetRoles().entrySet().forEach(entry -> response.header("X-Presto-Set-Role", (Object)((String)entry.getKey() + '=' + StatementResource.urlEncode(((SelectedRole)entry.getValue()).toString()))));
        for (Map.Entry<String, String> entry2 : query.getAddedPreparedStatements().entrySet()) {
            String encodedKey = StatementResource.urlEncode(entry2.getKey());
            String encodedValue = StatementResource.urlEncode(entry2.getValue());
            response.header("X-Presto-Added-Prepare", (Object)(encodedKey + '=' + encodedValue));
        }
        for (String name2 : query.getDeallocatedPreparedStatements()) {
            response.header("X-Presto-Deallocated-Prepare", (Object)StatementResource.urlEncode(name2));
        }
        query.getStartedTransactionId().ifPresent(transactionId -> response.header("X-Presto-Started-Transaction-Id", transactionId));
        if (query.isClearTransactionId()) {
            response.header("X-Presto-Clear-Transaction-Id", (Object)true);
        }
        return response.build();
    }

    @DELETE
    @Path(value="{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug) {
        Query query = this.getQuery(queryId, slug);
        if (query == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        query.cancel();
        return Response.noContent().build();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Managed
    @Nested
    public CounterStat getCreateQueryRequests() {
        return this.createQueryRequests;
    }
}

