/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.operator.unnest.Unnester;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.ColumnarMap;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;

class MapUnnester
extends Unnester {
    private ColumnarMap columnarMap;

    public MapUnnester(Type keyType, Type valueType) {
        super(keyType, valueType);
    }

    @Override
    protected void processCurrentPosition(int requiredOutputCount) {
        int i;
        int mapLength = this.columnarMap.getEntryCount(this.getCurrentPosition());
        int startingOffset = this.columnarMap.getOffset(this.getCurrentPosition());
        this.getBlockBuilder(0).appendRange(startingOffset, mapLength);
        for (i = 0; i < requiredOutputCount - mapLength; ++i) {
            this.getBlockBuilder(0).appendNull();
        }
        this.getBlockBuilder(1).appendRange(startingOffset, mapLength);
        for (i = 0; i < requiredOutputCount - mapLength; ++i) {
            this.getBlockBuilder(1).appendNull();
        }
    }

    @Override
    public int getChannelCount() {
        return 2;
    }

    @Override
    public int getInputEntryCount() {
        if (this.columnarMap == null) {
            return 0;
        }
        return this.columnarMap.getPositionCount();
    }

    @Override
    protected void resetColumnarStructure(Block block) {
        this.columnarMap = ColumnarMap.toColumnarMap((Block)block);
    }

    @Override
    protected Block getElementsBlock(int channel) {
        Preconditions.checkState((channel == 0 || channel == 1 ? 1 : 0) != 0, (Object)"index is not 0 or 1");
        if (channel == 0) {
            return this.columnarMap.getKeysBlock();
        }
        return this.columnarMap.getValuesBlock();
    }

    @Override
    protected int getElementsLength(int index) {
        return this.columnarMap.getEntryCount(index);
    }
}

