/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.MapGenericEquality;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.EQUAL)
public final class MapEqualOperator {
    private MapEqualOperator() {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlNullable
    @SqlType(value="boolean")
    public static Boolean equals(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"K", "K"}) MethodHandle keyEqualsFunction, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}) MethodHandle keyHashcodeFunction, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"V", "V"}) MethodHandle valueEqualsFunction, @TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType, @SqlType(value="map(K,V)") Block leftMapBlock, @SqlType(value="map(K,V)") Block rightMapBlock) {
        return MapGenericEquality.genericEqual(keyType, leftMapBlock, rightMapBlock, (leftMapIndex, rightMapIndex) -> {
            Object leftValue = TypeUtils.readNativeValue((Type)valueType, (Block)leftMapBlock, (int)leftMapIndex);
            if (leftValue == null) {
                return null;
            }
            Object rightValue = TypeUtils.readNativeValue((Type)valueType, (Block)rightMapBlock, (int)rightMapIndex);
            if (rightValue == null) {
                return null;
            }
            return valueEqualsFunction.invoke(leftValue, rightValue);
        });
    }
}

