/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.fixedhistogram;

import com.facebook.presto.operator.aggregation.fixedhistogram.FixedHistogramUtils;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.IntStream;
import org.openjdk.jol.info.ClassLayout;

public class FixedDoubleBreakdownHistogram
implements Iterable<Bucket> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FixedDoubleBreakdownHistogram.class).instanceSize();
    private int bucketCount;
    private double min;
    private double max;
    private int[] indices;
    private double[] weights;
    private long[] counts;

    public FixedDoubleBreakdownHistogram(int bucketCount, double min, double max) {
        FixedHistogramUtils.validateParameters(bucketCount, min, max);
        this.bucketCount = bucketCount;
        this.min = min;
        this.max = max;
        this.indices = new int[0];
        this.weights = new double[0];
        this.counts = new long[0];
    }

    private FixedDoubleBreakdownHistogram(FixedDoubleBreakdownHistogram other) {
        this.bucketCount = other.bucketCount;
        this.min = other.min;
        this.max = other.max;
        this.indices = Arrays.copyOf(other.indices, other.indices.length);
        this.weights = Arrays.copyOf(other.weights, other.weights.length);
        this.counts = Arrays.copyOf(other.counts, other.counts.length);
    }

    private FixedDoubleBreakdownHistogram(int bucketCount, double min, double max, int[] indices, double[] weights, long[] counts) {
        FixedHistogramUtils.validateParameters(bucketCount, min, max);
        this.bucketCount = bucketCount;
        this.min = min;
        this.max = max;
        this.indices = Objects.requireNonNull(indices, "indices is null");
        this.weights = Objects.requireNonNull(weights, "weights is null");
        this.counts = Objects.requireNonNull(counts, "counts is null");
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getWidth() {
        return (this.max - this.min) / (double)this.bucketCount;
    }

    public long estimatedInMemorySize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.indices) + SizeOf.sizeOf((double[])this.weights) + SizeOf.sizeOf((long[])this.counts);
    }

    public int getRequiredBytesForSerialization() {
        return 24 + this.indices.length * 20;
    }

    public static FixedDoubleBreakdownHistogram deserialize(SliceInput input) {
        int bucketCount = input.readInt();
        double min = input.readDouble();
        double max = input.readDouble();
        FixedHistogramUtils.validateParameters(bucketCount, min, max);
        int size = input.readInt();
        int[] indices = new int[size];
        double[] weights = new double[size];
        long[] counts = new long[size];
        input.readBytes(Slices.wrappedIntArray((int[])indices), size * 4);
        input.readBytes(Slices.wrappedDoubleArray((double[])weights), size * 8);
        input.readBytes(Slices.wrappedLongArray((long[])counts), size * 8);
        return new FixedDoubleBreakdownHistogram(bucketCount, min, max, indices, weights, counts);
    }

    public void serialize(SliceOutput out) {
        out.appendInt(this.bucketCount);
        out.appendDouble(this.min);
        out.appendDouble(this.max);
        out.appendInt(this.indices.length);
        IntStream.range(0, this.indices.length).forEach((int i) -> out.appendInt(this.indices[i]));
        IntStream.range(0, this.indices.length).forEach((int i) -> out.appendDouble(this.weights[i]));
        IntStream.range(0, this.indices.length).forEach((int i) -> out.appendLong(this.counts[i]));
    }

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double weight) {
        this.add(value, weight, 1L);
    }

    public void add(double value, double weight, long count) {
        int logicalBucketIndex = FixedHistogramUtils.getIndexForValue(this.bucketCount, this.min, this.max, value);
        this.add(logicalBucketIndex, weight, count);
    }

    private void add(int logicalBucketIndex, double weight, long count) {
        int foundIndex = this.lowerBoundBinarySearch(logicalBucketIndex, weight);
        if (foundIndex < this.indices.length && this.indices[foundIndex] == logicalBucketIndex && this.weights[foundIndex] == weight) {
            int n = foundIndex;
            this.counts[n] = this.counts[n] + count;
            return;
        }
        int[] newIndices = new int[this.indices.length + 1];
        System.arraycopy(this.indices, 0, newIndices, 0, foundIndex);
        newIndices[foundIndex] = logicalBucketIndex;
        System.arraycopy(this.indices, foundIndex, newIndices, foundIndex + 1, this.indices.length - foundIndex);
        this.indices = newIndices;
        double[] newWeights = new double[this.weights.length + 1];
        System.arraycopy(this.weights, 0, newWeights, 0, foundIndex);
        newWeights[foundIndex] = weight;
        System.arraycopy(this.weights, foundIndex, newWeights, foundIndex + 1, this.weights.length - foundIndex);
        this.weights = newWeights;
        long[] newCounts = new long[this.counts.length + 1];
        System.arraycopy(this.counts, 0, newCounts, 0, foundIndex);
        newCounts[foundIndex] = count;
        System.arraycopy(this.counts, foundIndex, newCounts, foundIndex + 1, this.counts.length - foundIndex);
        this.counts = newCounts;
    }

    public void mergeWith(FixedDoubleBreakdownHistogram other) {
        Preconditions.checkArgument((this.bucketCount == other.bucketCount ? 1 : 0) != 0, (Object)String.format("bucket count must be equal to other bucket count: %s %s", this.bucketCount, other.bucketCount));
        Preconditions.checkArgument((this.min == other.min ? 1 : 0) != 0, (Object)String.format("minimum must be equal to other minimum: %s %s", this.min, other.min));
        Preconditions.checkArgument((this.max == other.max ? 1 : 0) != 0, (Object)String.format("Maximum must be equal to other maximum: %s %s", this.max, other.max));
        for (int i = 0; i < other.indices.length; ++i) {
            this.add(other.indices[i], other.weights[i], other.counts[i]);
        }
    }

    @Override
    public Iterator<Bucket> iterator() {
        return new Iterator<Bucket>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < FixedDoubleBreakdownHistogram.this.indices.length;
            }

            @Override
            public Bucket next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Bucket bucket = new Bucket(FixedHistogramUtils.getLeftValueForIndex(FixedDoubleBreakdownHistogram.this.bucketCount, FixedDoubleBreakdownHistogram.this.min, FixedDoubleBreakdownHistogram.this.max, FixedDoubleBreakdownHistogram.this.indices[this.currentIndex]), FixedHistogramUtils.getRightValueForIndex(FixedDoubleBreakdownHistogram.this.bucketCount, FixedDoubleBreakdownHistogram.this.min, FixedDoubleBreakdownHistogram.this.max, FixedDoubleBreakdownHistogram.this.indices[this.currentIndex]), FixedDoubleBreakdownHistogram.this.weights[this.currentIndex], FixedDoubleBreakdownHistogram.this.counts[this.currentIndex]);
                ++this.currentIndex;
                return bucket;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public FixedDoubleBreakdownHistogram clone() {
        return new FixedDoubleBreakdownHistogram(this);
    }

    private int lowerBoundBinarySearch(int logicalBucketIndex, double weight) {
        int count = this.indices.length;
        int first = 0;
        while (count > 0) {
            int step = count / 2;
            int index = first + step;
            if (this.indices[index] < logicalBucketIndex || this.indices[index] == logicalBucketIndex && this.weights[index] < weight) {
                first = index + 1;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    public static class Bucket {
        private final double left;
        private final double right;
        private final double weight;
        private final long count;

        public double getLeft() {
            return this.left;
        }

        public double getRight() {
            return this.right;
        }

        public double getWeight() {
            return this.weight;
        }

        public long getCount() {
            return this.count;
        }

        public Bucket(double left, double right, double weight, long count) {
            this.left = left;
            this.right = right;
            this.weight = weight;
            this.count = count;
        }
    }
}

