/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import java.util.Arrays;

public class EntropyCalculations {
    private EntropyCalculations() {
    }

    public static double calculateFromSamples(double[] samples) {
        if (samples.length == 0) {
            return Double.NaN;
        }
        Arrays.sort(samples);
        int n = samples.length;
        int m = Math.toIntExact(Math.max(Math.round(Math.sqrt(n)), 2L));
        double entropy = 0.0;
        for (int i = 0; i < n; ++i) {
            double sIPlusM = i + m < n ? samples[i + m] : samples[n - 1];
            double sIMinusM = i - m > 0 ? samples[i - m] : samples[0];
            double aI = i + m < n && i - m > 0 ? 2.0 : 1.0;
            entropy += Math.log((double)n / (aI * (double)m) * (sIPlusM - sIMinusM));
        }
        return entropy / (double)n / Math.log(2.0);
    }
}

