/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyState;
import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.FixedHistogramJacknifeStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.FixedHistogramMleStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.UnweightedReservoirSampleStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.WeightedReservoirSampleStateStrategy;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DoubleType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import java.util.Locale;

@AggregationFunction(value="differential_entropy")
@Description(value="Computes differential entropy based on random-variable samples")
public final class DifferentialEntropyAggregation {
    @VisibleForTesting
    public static final String FIXED_HISTOGRAM_MLE_METHOD_NAME = "fixed_histogram_mle";
    @VisibleForTesting
    public static final String FIXED_HISTOGRAM_JACKNIFE_METHOD_NAME = "fixed_histogram_jacknife";

    private DifferentialEntropyAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState DifferentialEntropyState state, @SqlType(value="bigint") long size, @SqlType(value="double") double sample, @SqlType(value="double") double weight, @SqlType(value="varchar") Slice method, @SqlType(value="double") double min, @SqlType(value="double") double max) {
        String requestedMethod = method.toStringUtf8().toLowerCase(Locale.ENGLISH);
        DifferentialEntropyStateStrategy strategy = state.getStrategy();
        if (strategy == null) {
            switch (requestedMethod) {
                case "fixed_histogram_mle": {
                    strategy = new FixedHistogramMleStateStrategy(size, min, max);
                    break;
                }
                case "fixed_histogram_jacknife": {
                    strategy = new FixedHistogramJacknifeStateStrategy(size, min, max);
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, invalid method: %s", requestedMethod));
                }
            }
            state.setStrategy(strategy);
        } else {
            switch (requestedMethod.toLowerCase(Locale.ENGLISH)) {
                case "fixed_histogram_mle": {
                    Verify.verify((boolean)(strategy instanceof FixedHistogramMleStateStrategy), (String)String.format("Strategy class is not compatible with entropy method: %s %s", strategy.getClass().getSimpleName(), method), (Object[])new Object[0]);
                    break;
                }
                case "fixed_histogram_jacknife": {
                    Verify.verify((boolean)(strategy instanceof FixedHistogramJacknifeStateStrategy), (String)String.format("Strategy class is not compatible with entropy method: %s %s", strategy.getClass().getSimpleName(), method), (Object[])new Object[0]);
                    break;
                }
                default: {
                    Verify.verify((boolean)false, (String)String.format("Unknown entropy method %s", method), (Object[])new Object[0]);
                }
            }
        }
        strategy.validateParameters(size, sample, weight, min, max);
        strategy.add(sample, weight);
    }

    @InputFunction
    public static void input(@AggregationState DifferentialEntropyState state, @SqlType(value="bigint") long size, @SqlType(value="double") double sample, @SqlType(value="double") double weight) {
        DifferentialEntropyStateStrategy strategy = state.getStrategy();
        if (state.getStrategy() == null) {
            strategy = new WeightedReservoirSampleStateStrategy(size);
            state.setStrategy(strategy);
        } else {
            Verify.verify((boolean)(strategy instanceof WeightedReservoirSampleStateStrategy), (String)String.format("Expected WeightedReservoirSampleStateStrategy, got: %s", strategy.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        strategy.validateParameters(size, sample, weight);
        strategy.add(sample, weight);
    }

    @InputFunction
    public static void input(@AggregationState DifferentialEntropyState state, @SqlType(value="bigint") long size, @SqlType(value="double") double sample) {
        DifferentialEntropyStateStrategy strategy = state.getStrategy();
        if (state.getStrategy() == null) {
            strategy = new UnweightedReservoirSampleStateStrategy(size);
            state.setStrategy(strategy);
        } else {
            Verify.verify((boolean)(strategy instanceof UnweightedReservoirSampleStateStrategy), (String)String.format("Expected UnweightedReservoirSampleStateStrategy, got: %s", strategy.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        strategy.validateParameters(size, sample);
        strategy.add(sample, 1.0);
    }

    @CombineFunction
    public static void combine(@AggregationState DifferentialEntropyState state, @AggregationState DifferentialEntropyState otherState) {
        DifferentialEntropyStateStrategy strategy = state.getStrategy();
        DifferentialEntropyStateStrategy otherStrategy = otherState.getStrategy();
        if (strategy == null && otherStrategy != null) {
            state.setStrategy(otherStrategy);
            return;
        }
        if (otherStrategy == null) {
            return;
        }
        Verify.verify((strategy.getClass() == otherStrategy.getClass() ? 1 : 0) != 0, (String)String.format("In combine, %s != %s", strategy.getClass().getSimpleName(), otherStrategy.getClass().getSimpleName()), (Object[])new Object[0]);
        strategy.mergeWith(otherStrategy);
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState DifferentialEntropyState state, BlockBuilder out) {
        DifferentialEntropyStateStrategy strategy = state.getStrategy();
        DoubleType.DOUBLE.writeDouble(out, strategy == null ? Double.NaN : strategy.calculateEntropy());
    }
}

