/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.PrecisionRecallAggregation;
import com.facebook.presto.operator.aggregation.state.PrecisionRecallState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.type.DoubleType;
import java.util.Iterator;

@AggregationFunction(value="classification_fall_out")
@Description(value="Computes fall-out (false-positive rate) for binary classification")
public final class ClassificationFallOutAggregation
extends PrecisionRecallAggregation {
    private ClassificationFallOutAggregation() {
    }

    @OutputFunction(value="array(double)")
    public static void output(@AggregationState PrecisionRecallState state, BlockBuilder out) {
        Iterator<PrecisionRecallAggregation.BucketResult> resultsIterator = ClassificationFallOutAggregation.getResultsIterator(state);
        BlockBuilder entryBuilder = out.beginBlockEntry();
        while (resultsIterator.hasNext()) {
            PrecisionRecallAggregation.BucketResult result = resultsIterator.next();
            DoubleType.DOUBLE.writeDouble(entryBuilder, result.getFalsePositive() / result.getNegative());
        }
        out.closeEntry();
    }
}

