/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OperatorStats {
    private final int stageId;
    private final int pipelineId;
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private final long totalDrivers;
    private final long addInputCalls;
    private final Duration addInputWall;
    private final Duration addInputCpu;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize inputDataSize;
    private final long inputPositions;
    private final double sumSquaredInputPositions;
    private final long getOutputCalls;
    private final Duration getOutputWall;
    private final Duration getOutputCpu;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final DataSize physicalWrittenDataSize;
    private final Duration blockedWall;
    private final long finishCalls;
    private final Duration finishWall;
    private final Duration finishCpu;
    private final DataSize userMemoryReservation;
    private final DataSize revocableMemoryReservation;
    private final DataSize systemMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakSystemMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final DataSize spilledDataSize;
    private final Optional<BlockedReason> blockedReason;
    private final OperatorInfo info;

    @JsonCreator
    public OperatorStats(@JsonProperty(value="stageId") int stageId, @JsonProperty(value="pipelineId") int pipelineId, @JsonProperty(value="operatorId") int operatorId, @JsonProperty(value="planNodeId") PlanNodeId planNodeId, @JsonProperty(value="operatorType") String operatorType, @JsonProperty(value="totalDrivers") long totalDrivers, @JsonProperty(value="addInputCalls") long addInputCalls, @JsonProperty(value="addInputWall") Duration addInputWall, @JsonProperty(value="addInputCpu") Duration addInputCpu, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="inputDataSize") DataSize inputDataSize, @JsonProperty(value="inputPositions") long inputPositions, @JsonProperty(value="sumSquaredInputPositions") double sumSquaredInputPositions, @JsonProperty(value="getOutputCalls") long getOutputCalls, @JsonProperty(value="getOutputWall") Duration getOutputWall, @JsonProperty(value="getOutputCpu") Duration getOutputCpu, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="blockedWall") Duration blockedWall, @JsonProperty(value="finishCalls") long finishCalls, @JsonProperty(value="finishWall") Duration finishWall, @JsonProperty(value="finishCpu") Duration finishCpu, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="revocableMemoryReservation") DataSize revocableMemoryReservation, @JsonProperty(value="systemMemoryReservation") DataSize systemMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakSystemMemoryReservation") DataSize peakSystemMemoryReservation, @JsonProperty(value="peakTotalMemoryReservation") DataSize peakTotalMemoryReservation, @JsonProperty(value="spilledDataSize") DataSize spilledDataSize, @JsonProperty(value="blockedReason") Optional<BlockedReason> blockedReason, @JsonProperty(value="info") OperatorInfo info) {
        this.stageId = stageId;
        this.pipelineId = pipelineId;
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.totalDrivers = totalDrivers;
        this.addInputCalls = addInputCalls;
        this.addInputWall = Objects.requireNonNull(addInputWall, "addInputWall is null");
        this.addInputCpu = Objects.requireNonNull(addInputCpu, "addInputCpu is null");
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        this.rawInputPositions = Objects.requireNonNull(Long.valueOf(rawInputPositions), "rawInputPositions is null");
        this.inputDataSize = Objects.requireNonNull(inputDataSize, "inputDataSize is null");
        Preconditions.checkArgument((inputPositions >= 0L ? 1 : 0) != 0, (Object)"inputPositions is negative");
        this.inputPositions = inputPositions;
        this.sumSquaredInputPositions = sumSquaredInputPositions;
        this.getOutputCalls = getOutputCalls;
        this.getOutputWall = Objects.requireNonNull(getOutputWall, "getOutputWall is null");
        this.getOutputCpu = Objects.requireNonNull(getOutputCpu, "getOutputCpu is null");
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "writtenDataSize is null");
        this.blockedWall = Objects.requireNonNull(blockedWall, "blockedWall is null");
        this.finishCalls = finishCalls;
        this.finishWall = Objects.requireNonNull(finishWall, "finishWall is null");
        this.finishCpu = Objects.requireNonNull(finishCpu, "finishCpu is null");
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.revocableMemoryReservation = Objects.requireNonNull(revocableMemoryReservation, "revocableMemoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.peakSystemMemoryReservation = Objects.requireNonNull(peakSystemMemoryReservation, "peakSystemMemoryReservation is null");
        this.peakTotalMemoryReservation = Objects.requireNonNull(peakTotalMemoryReservation, "peakTotalMemoryReservation is null");
        this.spilledDataSize = Objects.requireNonNull(spilledDataSize, "spilledDataSize is null");
        this.blockedReason = blockedReason;
        this.info = info;
    }

    @JsonProperty
    public int getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public int getPipelineId() {
        return this.pipelineId;
    }

    @JsonProperty
    public int getOperatorId() {
        return this.operatorId;
    }

    @JsonProperty
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @JsonProperty
    public String getOperatorType() {
        return this.operatorType;
    }

    @JsonProperty
    public long getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public long getAddInputCalls() {
        return this.addInputCalls;
    }

    @JsonProperty
    public Duration getAddInputWall() {
        return this.addInputWall;
    }

    @JsonProperty
    public Duration getAddInputCpu() {
        return this.addInputCpu;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getInputDataSize() {
        return this.inputDataSize;
    }

    @JsonProperty
    public long getInputPositions() {
        return this.inputPositions;
    }

    @JsonProperty
    public double getSumSquaredInputPositions() {
        return this.sumSquaredInputPositions;
    }

    @JsonProperty
    public long getGetOutputCalls() {
        return this.getOutputCalls;
    }

    @JsonProperty
    public Duration getGetOutputWall() {
        return this.getOutputWall;
    }

    @JsonProperty
    public Duration getGetOutputCpu() {
        return this.getOutputCpu;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public Duration getBlockedWall() {
        return this.blockedWall;
    }

    @JsonProperty
    public long getFinishCalls() {
        return this.finishCalls;
    }

    @JsonProperty
    public Duration getFinishWall() {
        return this.finishWall;
    }

    @JsonProperty
    public Duration getFinishCpu() {
        return this.finishCpu;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getRevocableMemoryReservation() {
        return this.revocableMemoryReservation;
    }

    @JsonProperty
    public DataSize getSystemMemoryReservation() {
        return this.systemMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakSystemMemoryReservation() {
        return this.peakSystemMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    @JsonProperty
    public DataSize getSpilledDataSize() {
        return this.spilledDataSize;
    }

    @JsonProperty
    public Optional<BlockedReason> getBlockedReason() {
        return this.blockedReason;
    }

    @Nullable
    @JsonProperty
    public OperatorInfo getInfo() {
        return this.info;
    }

    public OperatorStats add(OperatorStats ... operators) {
        return this.add((Iterable<OperatorStats>)ImmutableList.copyOf((Object[])operators));
    }

    public OperatorStats add(Iterable<OperatorStats> operators) {
        long totalDrivers = this.totalDrivers;
        long addInputCalls = this.addInputCalls;
        long addInputWall = this.addInputWall.roundTo(TimeUnit.NANOSECONDS);
        long addInputCpu = this.addInputCpu.roundTo(TimeUnit.NANOSECONDS);
        long rawInputDataSize = this.rawInputDataSize.toBytes();
        long rawInputPositions = this.rawInputPositions;
        long inputDataSize = this.inputDataSize.toBytes();
        long inputPositions = this.inputPositions;
        double sumSquaredInputPositions = this.sumSquaredInputPositions;
        long getOutputCalls = this.getOutputCalls;
        long getOutputWall = this.getOutputWall.roundTo(TimeUnit.NANOSECONDS);
        long getOutputCpu = this.getOutputCpu.roundTo(TimeUnit.NANOSECONDS);
        long outputDataSize = this.outputDataSize.toBytes();
        long outputPositions = this.outputPositions;
        long physicalWrittenDataSize = this.physicalWrittenDataSize.toBytes();
        long blockedWall = this.blockedWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCalls = this.finishCalls;
        long finishWall = this.finishWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCpu = this.finishCpu.roundTo(TimeUnit.NANOSECONDS);
        long memoryReservation = this.userMemoryReservation.toBytes();
        long revocableMemoryReservation = this.revocableMemoryReservation.toBytes();
        long systemMemoryReservation = this.systemMemoryReservation.toBytes();
        long peakUserMemory = this.peakUserMemoryReservation.toBytes();
        long peakSystemMemory = this.peakSystemMemoryReservation.toBytes();
        long peakTotalMemory = this.peakTotalMemoryReservation.toBytes();
        long spilledDataSize = this.spilledDataSize.toBytes();
        Optional<BlockedReason> blockedReason = this.blockedReason;
        Mergeable<OperatorInfo> base = OperatorStats.getMergeableInfoOrNull(this.info);
        for (OperatorStats operator : operators) {
            Preconditions.checkArgument((operator.getOperatorId() == this.operatorId ? 1 : 0) != 0, (String)"Expected operatorId to be %s but was %s", (int)this.operatorId, (int)operator.getOperatorId());
            totalDrivers += operator.totalDrivers;
            addInputCalls += operator.getAddInputCalls();
            addInputWall += operator.getAddInputWall().roundTo(TimeUnit.NANOSECONDS);
            addInputCpu += operator.getAddInputCpu().roundTo(TimeUnit.NANOSECONDS);
            rawInputDataSize += operator.getRawInputDataSize().toBytes();
            rawInputPositions += operator.getRawInputPositions();
            inputDataSize += operator.getInputDataSize().toBytes();
            inputPositions += operator.getInputPositions();
            sumSquaredInputPositions += operator.getSumSquaredInputPositions();
            getOutputCalls += operator.getGetOutputCalls();
            getOutputWall += operator.getGetOutputWall().roundTo(TimeUnit.NANOSECONDS);
            getOutputCpu += operator.getGetOutputCpu().roundTo(TimeUnit.NANOSECONDS);
            outputDataSize += operator.getOutputDataSize().toBytes();
            outputPositions += operator.getOutputPositions();
            physicalWrittenDataSize += operator.getPhysicalWrittenDataSize().toBytes();
            finishCalls += operator.getFinishCalls();
            finishWall += operator.getFinishWall().roundTo(TimeUnit.NANOSECONDS);
            finishCpu += operator.getFinishCpu().roundTo(TimeUnit.NANOSECONDS);
            blockedWall += operator.getBlockedWall().roundTo(TimeUnit.NANOSECONDS);
            memoryReservation += operator.getUserMemoryReservation().toBytes();
            revocableMemoryReservation += operator.getRevocableMemoryReservation().toBytes();
            systemMemoryReservation += operator.getSystemMemoryReservation().toBytes();
            peakUserMemory = Math.max(peakUserMemory, operator.getPeakUserMemoryReservation().toBytes());
            peakSystemMemory = Math.max(peakSystemMemory, operator.getPeakSystemMemoryReservation().toBytes());
            peakTotalMemory = Math.max(peakTotalMemory, operator.getPeakTotalMemoryReservation().toBytes());
            spilledDataSize += operator.getSpilledDataSize().toBytes();
            if (operator.getBlockedReason().isPresent()) {
                blockedReason = operator.getBlockedReason();
            }
            OperatorInfo info = operator.getInfo();
            if (base == null || info == null || base.getClass() != info.getClass()) continue;
            base = OperatorStats.mergeInfo(base, info);
        }
        return new OperatorStats(this.stageId, this.pipelineId, this.operatorId, this.planNodeId, this.operatorType, totalDrivers, addInputCalls, Duration.succinctNanos((long)addInputWall), Duration.succinctNanos((long)addInputCpu), DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)inputDataSize), inputPositions, sumSquaredInputPositions, getOutputCalls, Duration.succinctNanos((long)getOutputWall), Duration.succinctNanos((long)getOutputCpu), DataSize.succinctBytes((long)outputDataSize), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), Duration.succinctNanos((long)blockedWall), finishCalls, Duration.succinctNanos((long)finishWall), Duration.succinctNanos((long)finishCpu), DataSize.succinctBytes((long)memoryReservation), DataSize.succinctBytes((long)revocableMemoryReservation), DataSize.succinctBytes((long)systemMemoryReservation), DataSize.succinctBytes((long)peakUserMemory), DataSize.succinctBytes((long)peakSystemMemory), DataSize.succinctBytes((long)peakTotalMemory), DataSize.succinctBytes((long)spilledDataSize), blockedReason, (OperatorInfo)((Object)base));
    }

    private static Mergeable<OperatorInfo> getMergeableInfoOrNull(OperatorInfo info) {
        Mergeable base = null;
        if (info instanceof Mergeable) {
            base = (Mergeable)((Object)info);
        }
        return base;
    }

    private static <T> Mergeable<T> mergeInfo(Mergeable<T> base, T other) {
        return (Mergeable)base.mergeWith(other);
    }

    public OperatorStats summarize() {
        return new OperatorStats(this.stageId, this.pipelineId, this.operatorId, this.planNodeId, this.operatorType, this.totalDrivers, this.addInputCalls, this.addInputWall, this.addInputCpu, this.rawInputDataSize, this.rawInputPositions, this.inputDataSize, this.inputPositions, this.sumSquaredInputPositions, this.getOutputCalls, this.getOutputWall, this.getOutputCpu, this.outputDataSize, this.outputPositions, this.physicalWrittenDataSize, this.blockedWall, this.finishCalls, this.finishWall, this.finishCpu, this.userMemoryReservation, this.revocableMemoryReservation, this.systemMemoryReservation, this.peakUserMemoryReservation, this.peakSystemMemoryReservation, this.peakTotalMemoryReservation, this.spilledDataSize, this.blockedReason, this.info != null && this.info.isFinal() ? this.info : null);
    }
}

