/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.StaticFunctionNamespaceStoreConfig;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class StaticFunctionNamespaceStore {
    private static final Logger log = Logger.get(StaticFunctionNamespaceStore.class);
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final FunctionManager functionManager;
    private final File configDir;
    private final AtomicBoolean functionNamespaceLoading = new AtomicBoolean();

    @Inject
    public StaticFunctionNamespaceStore(FunctionManager functionManager, StaticFunctionNamespaceStoreConfig config) {
        this.functionManager = functionManager;
        this.configDir = config.getFunctionNamespaceConfigurationDir();
    }

    public void loadFunctionNamespaceManagers() throws Exception {
        if (!this.functionNamespaceLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : StaticFunctionNamespaceStore.listFiles(this.configDir)) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            this.loadFunctionNamespaceManager(file);
        }
    }

    private void loadFunctionNamespaceManager(File file) throws Exception {
        log.info("-- Loading function namespace from %s --", new Object[]{file});
        HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(file));
        String functionNamespaceManagerName = (String)properties.remove("function-namespace-manager.name");
        Preconditions.checkState((functionNamespaceManagerName != null ? 1 : 0) != 0, (String)"Function namespace configuration %s does not contain function-namespace-manager.name", (Object)file.getAbsoluteFile());
        String functionNamespaces = (String)properties.remove("serving-namespaces");
        Preconditions.checkState((functionNamespaces != null ? 1 : 0) != 0, (String)"Function namespace configuration %s does not contain serving-namespaces", (Object)file.getAbsoluteFile());
        this.functionManager.loadFunctionNamespaces(functionNamespaceManagerName, SPLITTER.splitToList((CharSequence)functionNamespaces), properties);
        log.info("-- Added function namespace %s managed by function manager %s --", new Object[]{functionNamespaces, functionNamespaceManagerName});
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

