/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class SessionPropertyManager {
    private static final JsonCodecFactory JSON_CODEC_FACTORY = new JsonCodecFactory();
    private final ConcurrentMap<String, PropertyMetadata<?>> systemSessionProperties = new ConcurrentHashMap();
    private final ConcurrentMap<ConnectorId, Map<String, PropertyMetadata<?>>> connectorSessionProperties = new ConcurrentHashMap();

    public SessionPropertyManager() {
        this(new SystemSessionProperties());
    }

    @Inject
    public SessionPropertyManager(SystemSessionProperties systemSessionProperties) {
        this(systemSessionProperties.getSessionProperties());
    }

    public SessionPropertyManager(List<PropertyMetadata<?>> systemSessionProperties) {
        this.addSystemSessionProperties(systemSessionProperties);
    }

    public void addSystemSessionProperties(List<PropertyMetadata<?>> systemSessionProperties) {
        systemSessionProperties.forEach(this::addSystemSessionProperty);
    }

    public void addSystemSessionProperty(PropertyMetadata<?> sessionProperty) {
        Objects.requireNonNull(sessionProperty, "sessionProperty is null");
        Preconditions.checkState((this.systemSessionProperties.put(sessionProperty.getName(), sessionProperty) == null ? 1 : 0) != 0, (String)"System session property '%s' are already registered", (Object)sessionProperty.getName());
    }

    public void addConnectorSessionProperties(ConnectorId connectorId, List<PropertyMetadata<?>> properties) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(properties, "properties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(properties, PropertyMetadata::getName);
        Preconditions.checkState((this.connectorSessionProperties.putIfAbsent(connectorId, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"Session properties for connectorId '%s' are already registered", (Object)connectorId);
    }

    public void removeConnectorSessionProperties(ConnectorId connectorId) {
        this.connectorSessionProperties.remove(connectorId);
    }

    public Optional<PropertyMetadata<?>> getSystemSessionPropertyMetadata(String name) {
        Objects.requireNonNull(name, "name is null");
        return Optional.ofNullable(this.systemSessionProperties.get(name));
    }

    public Optional<PropertyMetadata<?>> getConnectorSessionPropertyMetadata(ConnectorId connectorId, String propertyName) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        Map properties = (Map)this.connectorSessionProperties.get(connectorId);
        if (properties == null || properties.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown connector " + connectorId);
        }
        return Optional.ofNullable(properties.get(propertyName));
    }

    public List<SessionPropertyValue> getAllSessionProperties(Session session, Map<String, ConnectorId> catalogs) {
        Objects.requireNonNull(session, "session is null");
        ImmutableList.Builder sessionPropertyValues = ImmutableList.builder();
        Map<String, String> systemProperties = session.getSystemProperties();
        for (PropertyMetadata<?> propertyMetadata : new TreeMap(this.systemSessionProperties).values()) {
            String defaultValue = MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString();
            String value = systemProperties.getOrDefault(propertyMetadata.getName(), defaultValue);
            sessionPropertyValues.add((Object)new SessionPropertyValue(value, defaultValue, propertyMetadata.getName(), Optional.empty(), propertyMetadata.getName(), propertyMetadata.getDescription(), propertyMetadata.getSqlType().getDisplayName(), propertyMetadata.isHidden()));
        }
        for (Map.Entry entry : new TreeMap<String, ConnectorId>(catalogs).entrySet()) {
            String catalog = (String)entry.getKey();
            ConnectorId connectorId = (ConnectorId)entry.getValue();
            Map<String, String> connectorProperties = session.getConnectorProperties(connectorId);
            for (PropertyMetadata property : new TreeMap((Map)this.connectorSessionProperties.get(connectorId)).values()) {
                String defaultValue = MoreObjects.firstNonNull((Object)property.getDefaultValue(), (Object)"").toString();
                String value = connectorProperties.getOrDefault(property.getName(), defaultValue);
                sessionPropertyValues.add((Object)new SessionPropertyValue(value, defaultValue, catalog + "." + property.getName(), Optional.of(catalog), property.getName(), property.getDescription(), property.getSqlType().getDisplayName(), property.isHidden()));
            }
        }
        return sessionPropertyValues.build();
    }

    public <T> T decodeSystemPropertyValue(String name, @Nullable String value, Class<T> type) {
        PropertyMetadata<?> property = this.getSystemSessionPropertyMetadata(name).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name));
        return SessionPropertyManager.decodePropertyValue(name, value, type, property);
    }

    public <T> T decodeCatalogPropertyValue(ConnectorId connectorId, String catalogName, String propertyName, @Nullable String propertyValue, Class<T> type) {
        String fullPropertyName = catalogName + "." + propertyName;
        PropertyMetadata<?> property = this.getConnectorSessionPropertyMetadata(connectorId, propertyName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + fullPropertyName));
        return SessionPropertyManager.decodePropertyValue(fullPropertyName, propertyValue, type, property);
    }

    public void validateSystemSessionProperty(String propertyName, String propertyValue) {
        PropertyMetadata<?> propertyMetadata = this.getSystemSessionPropertyMetadata(propertyName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + propertyName));
        SessionPropertyManager.decodePropertyValue(propertyName, propertyValue, propertyMetadata.getJavaType(), propertyMetadata);
    }

    public void validateCatalogSessionProperty(ConnectorId connectorId, String catalogName, String propertyName, String propertyValue) {
        String fullPropertyName = catalogName + "." + propertyName;
        PropertyMetadata<?> propertyMetadata = this.getConnectorSessionPropertyMetadata(connectorId, propertyName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + fullPropertyName));
        SessionPropertyManager.decodePropertyValue(fullPropertyName, propertyValue, propertyMetadata.getJavaType(), propertyMetadata);
    }

    private static <T> T decodePropertyValue(String fullPropertyName, @Nullable String propertyValue, Class<T> type, PropertyMetadata<?> metadata) {
        if (metadata.getJavaType() != type) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Property %s is type %s, but requested type was %s", fullPropertyName, metadata.getJavaType().getName(), type.getName()));
        }
        if (propertyValue == null) {
            return type.cast(metadata.getDefaultValue());
        }
        Object objectValue = SessionPropertyManager.deserializeSessionProperty(metadata.getSqlType(), propertyValue);
        try {
            return type.cast(metadata.decode(objectValue));
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s is invalid: %s", fullPropertyName, propertyValue), (Throwable)e);
        }
    }

    public static Object evaluatePropertyValue(Expression expression, Type expectedType, Session session, Metadata metadata, List<Expression> parameters) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)expression);
        Object value = ExpressionInterpreter.evaluateConstantExpression(rewritten, expectedType, metadata, session, parameters);
        BlockBuilder blockBuilder = expectedType.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
        Object objectValue = expectedType.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
        if (objectValue == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property value must not be null");
        }
        return objectValue;
    }

    public static String serializeSessionProperty(Type type, Object value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property can not be null");
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return value.toString();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return value.toString();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return value.toString();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return value.toString();
        }
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return value.toString();
        }
        if (type instanceof ArrayType || type instanceof MapType) {
            return SessionPropertyManager.getJsonCodecForType(type).toJson(value);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static Object deserializeSessionProperty(Type type, String value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property can not be null");
        }
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return value;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return Boolean.valueOf(value);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return Long.valueOf(value);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return Integer.valueOf(value);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return Double.valueOf(value);
        }
        if (type instanceof ArrayType || type instanceof MapType) {
            return SessionPropertyManager.getJsonCodecForType(type).fromJson(value);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static <T> JsonCodec<T> getJsonCodecForType(Type type) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(String.class);
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Boolean.class);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Long.class);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Integer.class);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Double.class);
        }
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            return JSON_CODEC_FACTORY.listJsonCodec(SessionPropertyManager.getJsonCodecForType(elementType));
        }
        if (type instanceof MapType) {
            Type keyType = ((MapType)type).getKeyType();
            Type valueType = ((MapType)type).getValueType();
            return JSON_CODEC_FACTORY.mapJsonCodec(SessionPropertyManager.getMapKeyType(keyType), SessionPropertyManager.getJsonCodecForType(valueType));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static Class<?> getMapKeyType(Type type) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return String.class;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return Boolean.class;
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return Long.class;
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return Integer.class;
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return Double.class;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property map key type %s is not supported", type));
    }

    public static class SessionPropertyValue {
        private final String fullyQualifiedName;
        private final Optional<String> catalogName;
        private final String propertyName;
        private final String description;
        private final String type;
        private final String value;
        private final String defaultValue;
        private final boolean hidden;

        private SessionPropertyValue(String value, String defaultValue, String fullyQualifiedName, Optional<String> catalogName, String propertyName, String description, String type, boolean hidden) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.catalogName = catalogName;
            this.propertyName = propertyName;
            this.description = description;
            this.type = type;
            this.value = value;
            this.defaultValue = defaultValue;
            this.hidden = hidden;
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public Optional<String> getCatalogName() {
            return this.catalogName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isHidden() {
            return this.hidden;
        }
    }
}

