/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunctionHandle;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionInvokerProvider;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.type.UnknownType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class FunctionManager
implements FunctionMetadataManager {
    private final TypeManager typeManager;
    private final BuiltInFunctionNamespaceManager builtInFunctionNamespace;
    private final FunctionInvokerProvider functionInvokerProvider;
    private final Map<String, FunctionNamespaceManagerFactory> functionNamespaceFactories = new ConcurrentHashMap<String, FunctionNamespaceManagerFactory>();
    private final HandleResolver handleResolver;
    private final Map<FullyQualifiedName.Prefix, FunctionNamespaceManager> functionNamespaces = new ConcurrentHashMap<FullyQualifiedName.Prefix, FunctionNamespaceManager>();

    @Inject
    public FunctionManager(TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig, HandleResolver handleResolver) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.builtInFunctionNamespace = new BuiltInFunctionNamespaceManager(typeManager, blockEncodingSerde, featuresConfig, this);
        this.functionNamespaces.put(BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, this.builtInFunctionNamespace);
        this.functionInvokerProvider = new FunctionInvokerProvider(this);
        this.handleResolver = handleResolver;
        if (typeManager instanceof TypeRegistry) {
            ((TypeRegistry)typeManager).setFunctionManager(this);
        }
    }

    @VisibleForTesting
    public FunctionManager(TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig) {
        this(typeManager, blockEncodingSerde, featuresConfig, new HandleResolver());
    }

    public void loadFunctionNamespaces(String functionNamespaceManagerName, List<String> functionNamespacePrefixes, Map<String, String> properties) {
        Objects.requireNonNull(functionNamespaceManagerName, "connectorName is null");
        FunctionNamespaceManagerFactory factory = this.functionNamespaceFactories.get(functionNamespaceManagerName);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"No function namespace manager for %s", (Object)functionNamespaceManagerName);
        FunctionNamespaceManager manager = factory.create(properties);
        for (String functionNamespacePrefix : functionNamespacePrefixes) {
            if (this.functionNamespaces.putIfAbsent(FullyQualifiedName.Prefix.of((String)functionNamespacePrefix), manager) == null) continue;
            throw new IllegalArgumentException(String.format("Function namespace manager '%s' already registered to handle function namespace '%s'", factory.getName(), functionNamespacePrefix));
        }
    }

    public FunctionInvokerProvider getFunctionInvokerProvider() {
        return this.functionInvokerProvider;
    }

    public void addFunctionNamespaceFactory(FunctionNamespaceManagerFactory factory) {
        if (this.functionNamespaceFactories.putIfAbsent(factory.getName(), factory) != null) {
            throw new IllegalArgumentException(String.format("Resource group configuration manager '%s' is already registered", factory.getName()));
        }
        this.handleResolver.addFunctionNamepsace(factory.getName(), factory.getHandleResolver());
    }

    public void addFunctions(List<? extends SqlFunction> functions) {
        this.builtInFunctionNamespace.addFunctions(functions);
    }

    public List<SqlFunction> listFunctions() {
        return (List)this.builtInFunctionNamespace.listFunctions().stream().filter(function -> !function.isHidden()).collect(ImmutableList.toImmutableList());
    }

    public FunctionHandle resolveFunction(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        FullyQualifiedName fullyQualifiedName = !name.getPrefix().isPresent() ? FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)name.getSuffix()) : FullyQualifiedName.of((List)name.getOriginalParts());
        Optional<FunctionNamespaceManager> servingNamespaceManager = this.getServingNamespaceManager(fullyQualifiedName);
        if (!servingNamespaceManager.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Cannot find function namespace for function %s", name));
        }
        QueryId queryId = session == null ? null : session.getQueryId();
        Collection allCandidates = servingNamespaceManager.get().getCandidates(queryId, fullyQualifiedName);
        try {
            return this.lookupFunction(servingNamespaceManager.get(), queryId, fullyQualifiedName, parameterTypes, allCandidates);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() != StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw e;
            }
            Optional<Signature> match = this.matchFunctionWithCoercion(allCandidates, parameterTypes);
            if (match.isPresent()) {
                return servingNamespaceManager.get().getFunctionHandle(queryId, match.get());
            }
            if (name.getSuffix().startsWith("$literal$")) {
                String typeName = name.getSuffix().substring("$literal$".length());
                Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)typeName));
                Preconditions.checkArgument((parameterTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", parameterTypes);
                return new BuiltInFunctionHandle(LiteralEncoder.getMagicLiteralFunctionSignature(type));
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, this.constructFunctionNotFoundErrorMessage(name.toString(), parameterTypes, allCandidates));
        }
    }

    public FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
        return this.functionNamespaces.get(functionHandle.getFunctionNamespace()).getFunctionMetadata(functionHandle);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionHandle functionHandle) {
        return this.builtInFunctionNamespace.getWindowFunctionImplementation(functionHandle);
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(FunctionHandle functionHandle) {
        return this.builtInFunctionNamespace.getAggregateFunctionImplementation(functionHandle);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        return this.builtInFunctionNamespace.getScalarFunctionImplementation(functionHandle);
    }

    @VisibleForTesting
    public List<SqlFunction> listOperators() {
        Set operatorNames = (Set)Arrays.asList(OperatorType.values()).stream().map(OperatorType::getFunctionName).collect(ImmutableSet.toImmutableSet());
        return (List)this.builtInFunctionNamespace.listFunctions().stream().filter(function -> operatorNames.contains(function.getSignature().getName())).collect(ImmutableList.toImmutableList());
    }

    public FunctionHandle resolveOperator(OperatorType operatorType, List<TypeSignatureProvider> argumentTypes) {
        try {
            return this.resolveFunction(null, QualifiedName.of((Iterable)operatorType.getFunctionName().getParts()), argumentTypes);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(operatorType, (List)argumentTypes.stream().map(TypeSignatureProvider::getTypeSignature).collect(ImmutableList.toImmutableList()));
            }
            throw e;
        }
    }

    public FunctionHandle lookupFunction(String name, List<TypeSignatureProvider> parameterTypes) {
        FullyQualifiedName fullyQualifiedName = FullyQualifiedName.of((FullyQualifiedName.Prefix)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)name);
        Collection<SqlFunction> allCandidates = this.builtInFunctionNamespace.getCandidates(null, fullyQualifiedName);
        return this.lookupFunction(this.builtInFunctionNamespace, null, fullyQualifiedName, parameterTypes, allCandidates);
    }

    public FunctionHandle lookupCast(CastType castType, TypeSignature fromType, TypeSignature toType) {
        Signature signature = new Signature(castType.getCastName(), FunctionKind.SCALAR, Collections.emptyList(), Collections.emptyList(), toType, Collections.singletonList(fromType), false);
        try {
            this.builtInFunctionNamespace.getScalarFunctionImplementation(signature);
        }
        catch (PrestoException e) {
            if (castType.isOperatorType() && e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(CastType.toOperatorType(castType), (List<TypeSignature>)ImmutableList.of((Object)fromType), toType);
            }
            throw e;
        }
        return this.builtInFunctionNamespace.getFunctionHandle(null, signature);
    }

    private FunctionHandle lookupFunction(FunctionNamespaceManager functionNamespaceManager, QueryId queryId, FullyQualifiedName name, List<TypeSignatureProvider> parameterTypes, Collection<SqlFunction> allCandidates) {
        List<SqlFunction> exactCandidates = allCandidates.stream().filter(function -> function.getSignature().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
        Optional<Signature> match = this.matchFunctionExact(exactCandidates, parameterTypes);
        if (match.isPresent()) {
            return functionNamespaceManager.getFunctionHandle(queryId, match.get());
        }
        List<SqlFunction> genericCandidates = allCandidates.stream().filter(function -> !function.getSignature().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
        match = this.matchFunctionExact(genericCandidates, parameterTypes);
        if (match.isPresent()) {
            return functionNamespaceManager.getFunctionHandle(queryId, match.get());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, this.constructFunctionNotFoundErrorMessage(name.toString(), parameterTypes, allCandidates));
    }

    private Optional<FunctionNamespaceManager> getServingNamespaceManager(FullyQualifiedName name) {
        FullyQualifiedName.Prefix functionPrefix = name.getPrefix();
        if (functionPrefix.equals((Object)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE)) {
            return Optional.of(this.builtInFunctionNamespace);
        }
        FullyQualifiedName.Prefix bestMatchNamespace = null;
        FunctionNamespaceManager servingNamespaceManager = null;
        for (Map.Entry<FullyQualifiedName.Prefix, FunctionNamespaceManager> functionNamespace : this.functionNamespaces.entrySet()) {
            if (!functionNamespace.getKey().contains(functionPrefix) || bestMatchNamespace != null && !bestMatchNamespace.contains(functionNamespace.getKey())) continue;
            bestMatchNamespace = functionNamespace.getKey();
            servingNamespaceManager = functionNamespace.getValue();
        }
        return Optional.ofNullable(servingNamespaceManager);
    }

    private String constructFunctionNotFoundErrorMessage(String name, List<TypeSignatureProvider> parameterTypes, Collection<SqlFunction> candidates) {
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (SqlFunction function : candidates) {
            expectedParameters.add(String.format("%s(%s) %s", name, Joiner.on((String)", ").join((Iterable)function.getSignature().getArgumentTypes()), Joiner.on((String)", ").join((Iterable)function.getSignature().getTypeVariableConstraints())));
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String message = String.format("Function %s not registered", name);
        if (!expectedParameters.isEmpty()) {
            String expected = Joiner.on((String)", ").join(expectedParameters);
            message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        }
        return message;
    }

    private Optional<Signature> matchFunctionExact(List<SqlFunction> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, false);
    }

    private Optional<Signature> matchFunctionWithCoercion(Collection<SqlFunction> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, true);
    }

    private Optional<Signature> matchFunction(Collection<SqlFunction> candidates, List<TypeSignatureProvider> parameters, boolean coercionAllowed) {
        List<ApplicableFunction> applicableFunctions = this.identifyApplicableFunctions(candidates, parameters, coercionAllowed);
        if (applicableFunctions.isEmpty()) {
            return Optional.empty();
        }
        if (coercionAllowed) {
            Preconditions.checkState((!(applicableFunctions = this.selectMostSpecificFunctions(applicableFunctions, parameters)).isEmpty() ? 1 : 0) != 0, (Object)"at least single function must be left");
        }
        if (applicableFunctions.size() == 1) {
            return Optional.of(((ApplicableFunction)Iterables.getOnlyElement(applicableFunctions)).getBoundSignature());
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Could not choose a best candidate operator. Explicit type casts must be added.\n");
        errorMessageBuilder.append("Candidates are:\n");
        for (ApplicableFunction function : applicableFunctions) {
            errorMessageBuilder.append("\t * ");
            errorMessageBuilder.append(function.getBoundSignature().toString());
            errorMessageBuilder.append("\n");
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, errorMessageBuilder.toString());
    }

    private List<ApplicableFunction> identifyApplicableFunctions(Collection<SqlFunction> candidates, List<TypeSignatureProvider> actualParameters, boolean allowCoercion) {
        ImmutableList.Builder applicableFunctions = ImmutableList.builder();
        for (SqlFunction function : candidates) {
            Signature declaredSignature = function.getSignature();
            Optional<Signature> boundSignature = new SignatureBinder(this.typeManager, declaredSignature, allowCoercion).bind(actualParameters);
            if (!boundSignature.isPresent()) continue;
            applicableFunctions.add((Object)new ApplicableFunction(declaredSignature, boundSignature.get(), function.isCalledOnNullInput()));
        }
        return applicableFunctions.build();
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> applicableFunctions, List<TypeSignatureProvider> parameters) {
        Preconditions.checkArgument((!applicableFunctions.isEmpty() ? 1 : 0) != 0);
        List<ApplicableFunction> mostSpecificFunctions = this.selectMostSpecificFunctions(applicableFunctions);
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        Optional<List<Type>> optionalParameterTypes = FunctionManager.toTypes(parameters, this.typeManager);
        if (!optionalParameterTypes.isPresent()) {
            return mostSpecificFunctions;
        }
        List<Type> parameterTypes = optionalParameterTypes.get();
        if (!FunctionManager.someParameterIsUnknown(parameterTypes)) {
            return mostSpecificFunctions;
        }
        List<ApplicableFunction> unknownOnlyCastFunctions = this.getUnknownOnlyCastFunctions(applicableFunctions, parameterTypes);
        if (!unknownOnlyCastFunctions.isEmpty() && (mostSpecificFunctions = unknownOnlyCastFunctions).size() == 1) {
            return mostSpecificFunctions;
        }
        if (this.returnTypeIsTheSame(mostSpecificFunctions) && this.allReturnNullOnGivenInputTypes(mostSpecificFunctions, parameterTypes)) {
            ApplicableFunction selectedFunction = (ApplicableFunction)Ordering.usingToString().reverse().sortedCopy(mostSpecificFunctions).get(0);
            return ImmutableList.of((Object)selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> candidates) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean found = false;
            for (int i = 0; i < representatives.size(); ++i) {
                ApplicableFunction representative = (ApplicableFunction)representatives.get(i);
                if (this.isMoreSpecificThan(current, representative)) {
                    representatives.set(i, current);
                }
                if (!this.isMoreSpecificThan(current, representative) && !this.isMoreSpecificThan(representative, current)) continue;
                found = true;
                break;
            }
            if (found) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private static boolean someParameterIsUnknown(List<Type> parameters) {
        return parameters.stream().anyMatch(type -> type.equals((Object)UnknownType.UNKNOWN));
    }

    private List<ApplicableFunction> getUnknownOnlyCastFunctions(List<ApplicableFunction> applicableFunction, List<Type> actualParameters) {
        return (List)applicableFunction.stream().filter(function -> this.onlyCastsUnknown((ApplicableFunction)function, actualParameters)).collect(ImmutableList.toImmutableList());
    }

    private boolean onlyCastsUnknown(ApplicableFunction applicableFunction, List<Type> actualParameters) {
        List<Type> boundTypes = TypeUtils.resolveTypes(applicableFunction.getBoundSignature().getArgumentTypes(), this.typeManager);
        Preconditions.checkState((actualParameters.size() == boundTypes.size() ? 1 : 0) != 0, (Object)"type lists are of different lengths");
        for (int i = 0; i < actualParameters.size(); ++i) {
            if (boundTypes.get(i).equals(actualParameters.get(i)) || actualParameters.get(i) == UnknownType.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    private boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> this.typeManager.getType(function.getBoundSignature().getReturnType())).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private boolean allReturnNullOnGivenInputTypes(List<ApplicableFunction> applicableFunctions, List<Type> parameters) {
        return applicableFunctions.stream().allMatch(x -> this.returnsNullOnGivenInputTypes((ApplicableFunction)x, parameters));
    }

    private boolean returnsNullOnGivenInputTypes(ApplicableFunction applicableFunction, List<Type> parameterTypes) {
        Signature boundSignature = applicableFunction.getBoundSignature();
        FunctionKind functionKind = boundSignature.getKind();
        if (functionKind != FunctionKind.SCALAR) {
            return true;
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Type parameterType = parameterTypes.get(i);
            if (!parameterType.equals((Object)UnknownType.UNKNOWN) || !applicableFunction.isCalledOnNullInput()) continue;
            return false;
        }
        return true;
    }

    private static Optional<List<Type>> toTypes(List<TypeSignatureProvider> typeSignatureProviders, TypeManager typeManager) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (TypeSignatureProvider typeSignatureProvider : typeSignatureProviders) {
            if (typeSignatureProvider.hasDependency()) {
                return Optional.empty();
            }
            resultBuilder.add((Object)typeManager.getType(typeSignatureProvider.getTypeSignature()));
        }
        return Optional.of(resultBuilder.build());
    }

    private boolean isMoreSpecificThan(ApplicableFunction left, ApplicableFunction right) {
        List<TypeSignatureProvider> resolvedTypes = TypeSignatureProvider.fromTypeSignatures(left.getBoundSignature().getArgumentTypes());
        Optional<BoundVariables> boundVariables = new SignatureBinder(this.typeManager, right.getDeclaredSignature(), true).bindVariables(resolvedTypes);
        return boundVariables.isPresent();
    }

    private static class ApplicableFunction {
        private final Signature declaredSignature;
        private final Signature boundSignature;
        private final boolean isCalledOnNullInput;

        private ApplicableFunction(Signature declaredSignature, Signature boundSignature, boolean isCalledOnNullInput) {
            this.declaredSignature = declaredSignature;
            this.boundSignature = boundSignature;
            this.isCalledOnNullInput = isCalledOnNullInput;
        }

        public Signature getDeclaredSignature() {
            return this.declaredSignature;
        }

        public Signature getBoundSignature() {
            return this.boundSignature;
        }

        public boolean isCalledOnNullInput() {
            return this.isCalledOnNullInput;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaredSignature", (Object)this.declaredSignature).add("boundSignature", (Object)this.boundSignature).toString();
        }
    }
}

