/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event;

import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.event.QueryMonitorConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TableFinishInfo;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryContext;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryFailureInfo;
import com.facebook.presto.spi.eventlistener.QueryIOMetadata;
import com.facebook.presto.spi.eventlistener.QueryInputMetadata;
import com.facebook.presto.spi.eventlistener.QueryMetadata;
import com.facebook.presto.spi.eventlistener.QueryOutputMetadata;
import com.facebook.presto.spi.eventlistener.QueryStatistics;
import com.facebook.presto.spi.eventlistener.StageCpuDistribution;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.transaction.TransactionId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.stats.Distribution;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class QueryMonitor {
    private static final Logger log = Logger.get(QueryMonitor.class);
    private static final JsonCodec<Map<PlanFragmentId, JsonPlanFragment>> PLAN_MAP_CODEC = JsonCodec.mapJsonCodec(PlanFragmentId.class, JsonPlanFragment.class);
    private final JsonCodec<StageInfo> stageInfoCodec;
    private final JsonCodec<OperatorStats> operatorStatsCodec;
    private final JsonCodec<ExecutionFailureInfo> executionFailureInfoCodec;
    private final EventListenerManager eventListenerManager;
    private final String serverVersion;
    private final String serverAddress;
    private final String environment;
    private final SessionPropertyManager sessionPropertyManager;
    private final FunctionManager functionManager;
    private final int maxJsonLimit;

    @Inject
    public QueryMonitor(JsonCodec<StageInfo> stageInfoCodec, JsonCodec<OperatorStats> operatorStatsCodec, JsonCodec<ExecutionFailureInfo> executionFailureInfoCodec, EventListenerManager eventListenerManager, NodeInfo nodeInfo, NodeVersion nodeVersion, SessionPropertyManager sessionPropertyManager, Metadata metadata, QueryMonitorConfig config) {
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.stageInfoCodec = Objects.requireNonNull(stageInfoCodec, "stageInfoCodec is null");
        this.operatorStatsCodec = Objects.requireNonNull(operatorStatsCodec, "operatorStatsCodec is null");
        this.executionFailureInfoCodec = Objects.requireNonNull(executionFailureInfoCodec, "executionFailureInfoCodec is null");
        this.serverVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
        this.serverAddress = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getExternalAddress();
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.functionManager = Objects.requireNonNull(metadata, "metadata is null").getFunctionManager();
        this.maxJsonLimit = Math.toIntExact(Objects.requireNonNull(config, "config is null").getMaxOutputStageJsonSize().toBytes());
    }

    public void queryCreatedEvent(BasicQueryInfo queryInfo) {
        this.eventListenerManager.queryCreated(new QueryCreatedEvent(queryInfo.getQueryStats().getCreateTime().toDate().toInstant(), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), QueryState.QUEUED.toString(), queryInfo.getSelf(), Optional.empty(), Optional.empty(), Optional.empty())));
    }

    public void queryImmediateFailureEvent(BasicQueryInfo queryInfo, ExecutionFailureInfo failure) {
        this.eventListenerManager.queryCompleted(new QueryCompletedEvent(new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getState().toString(), queryInfo.getSelf(), Optional.empty(), Optional.empty(), Optional.empty()), new QueryStatistics(Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(0L), Optional.empty(), 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0.0, (List)ImmutableList.of(), 0, true, (List)ImmutableList.of(), (List)ImmutableList.of()), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), new QueryIOMetadata((List)ImmutableList.of(), Optional.empty()), this.createQueryFailureInfo(failure, Optional.empty()), (List)ImmutableList.of(), queryInfo.getQueryType(), (List)ImmutableList.of(), Instant.ofEpochMilli(queryInfo.getQueryStats().getCreateTime().getMillis()), Instant.ofEpochMilli(queryInfo.getQueryStats().getCreateTime().getMillis()), Instant.ofEpochMilli(queryInfo.getQueryStats().getEndTime().getMillis())));
        QueryMonitor.logQueryTimeline(queryInfo);
    }

    public void queryCompletedEvent(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        this.eventListenerManager.queryCompleted(new QueryCompletedEvent(this.createQueryMetadata(queryInfo), this.createQueryStatistics(queryInfo), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), QueryMonitor.getQueryIOMetadata(queryInfo), this.createQueryFailureInfo(queryInfo.getFailureInfo(), queryInfo.getOutputStage()), queryInfo.getWarnings(), queryInfo.getQueryType(), (List)queryInfo.getFailedTasks().orElse((List<TaskId>)ImmutableList.of()).stream().map(TaskId::toString).collect(ImmutableList.toImmutableList()), Instant.ofEpochMilli(queryStats.getCreateTime().getMillis()), Instant.ofEpochMilli(queryStats.getExecutionStartTime().getMillis()), Instant.ofEpochMilli(queryStats.getEndTime() != null ? queryStats.getEndTime().getMillis() : 0L)));
        QueryMonitor.logQueryTimeline(queryInfo);
    }

    private QueryMetadata createQueryMetadata(QueryInfo queryInfo) {
        return new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getState().toString(), queryInfo.getSelf(), this.createTextQueryPlan(queryInfo), this.createJsonQueryPlan(queryInfo), queryInfo.getOutputStage().flatMap(stage -> this.stageInfoCodec.toJsonWithLengthLimit(stage, this.maxJsonLimit)));
    }

    private QueryStatistics createQueryStatistics(QueryInfo queryInfo) {
        ImmutableList.Builder operatorSummaries = ImmutableList.builder();
        for (OperatorStats summary : queryInfo.getQueryStats().getOperatorSummaries()) {
            operatorSummaries.add((Object)this.operatorStatsCodec.toJson((Object)summary));
        }
        QueryStats queryStats = queryInfo.getQueryStats();
        return new QueryStatistics(Duration.ofMillis(queryStats.getTotalCpuTime().toMillis()), Duration.ofMillis(queryStats.getTotalScheduledTime().toMillis()), Duration.ofMillis(queryStats.getQueuedTime().toMillis()), Optional.of(Duration.ofMillis(queryStats.getAnalysisTime().toMillis())), queryStats.getPeakRunningTasks(), queryStats.getPeakUserMemoryReservation().toBytes(), queryStats.getPeakTotalMemoryReservation().toBytes(), queryStats.getPeakTaskUserMemory().toBytes(), queryStats.getPeakTaskTotalMemory().toBytes(), queryStats.getRawInputDataSize().toBytes(), queryStats.getRawInputPositions(), queryStats.getOutputDataSize().toBytes(), queryStats.getOutputPositions(), queryStats.getWrittenOutputLogicalDataSize().toBytes(), queryStats.getWrittenOutputPositions(), queryStats.getWrittenIntermediatePhysicalDataSize().toBytes(), queryStats.getCumulativeUserMemory(), queryStats.getStageGcStatistics(), queryStats.getCompletedDrivers(), queryInfo.isCompleteInfo(), QueryMonitor.getCpuDistributions(queryInfo), (List)operatorSummaries.build());
    }

    private QueryContext createQueryContext(SessionRepresentation session, Optional<ResourceGroupId> resourceGroup) {
        return new QueryContext(session.getUser(), session.getPrincipal(), session.getRemoteUserAddress(), session.getUserAgent(), session.getClientInfo(), session.getClientTags(), session.getSource(), session.getCatalog(), session.getSchema(), resourceGroup, QueryMonitor.mergeSessionAndCatalogProperties(session), session.getResourceEstimates(), this.serverAddress, this.serverVersion, this.environment);
    }

    private Optional<String> createTextQueryPlan(QueryInfo queryInfo) {
        try {
            if (queryInfo.getOutputStage().isPresent()) {
                return Optional.of(PlanPrinter.textDistributedPlan(queryInfo.getOutputStage().get(), this.functionManager, queryInfo.getSession().toSession(this.sessionPropertyManager), false));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error creating explain plan for query %s", new Object[]{queryInfo.getQueryId()});
        }
        return Optional.empty();
    }

    private Optional<String> createJsonQueryPlan(QueryInfo queryInfo) {
        try {
            if (queryInfo.getOutputStage().isPresent()) {
                ImmutableSortedMap.Builder fragmentJsonMap = ImmutableSortedMap.naturalOrder();
                for (StageInfo stage : StageInfo.getAllStages(queryInfo.getOutputStage())) {
                    PlanFragmentId fragmentId = stage.getPlan().get().getId();
                    JsonPlanFragment jsonPlanFragment = new JsonPlanFragment(stage.getPlan().get().getJsonRepresentation().get());
                    fragmentJsonMap.put((Object)fragmentId, (Object)jsonPlanFragment);
                }
                return Optional.of(PLAN_MAP_CODEC.toJson((Object)fragmentJsonMap.build()));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error creating json plan for query %s: %s", new Object[]{queryInfo.getQueryId(), e});
        }
        return Optional.empty();
    }

    private static QueryIOMetadata getQueryIOMetadata(QueryInfo queryInfo) {
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (Input input : queryInfo.getInputs()) {
            inputs.add((Object)new QueryInputMetadata(input.getConnectorId().getCatalogName(), input.getSchema(), input.getTable(), input.getColumns().stream().map(Column::getName).collect(Collectors.toList()), input.getConnectorInfo(), input.getStatistics()));
        }
        Optional<Object> output = Optional.empty();
        if (queryInfo.getOutput().isPresent()) {
            Optional<TableFinishInfo> tableFinishInfo = queryInfo.getQueryStats().getOperatorSummaries().stream().map(OperatorStats::getInfo).filter(TableFinishInfo.class::isInstance).map(TableFinishInfo.class::cast).findFirst();
            output = Optional.of(new QueryOutputMetadata(queryInfo.getOutput().get().getConnectorId().getCatalogName(), queryInfo.getOutput().get().getSchema(), queryInfo.getOutput().get().getTable(), tableFinishInfo.map(TableFinishInfo::getConnectorOutputMetadata), tableFinishInfo.map(TableFinishInfo::isJsonLengthLimitExceeded)));
        }
        return new QueryIOMetadata((List)inputs.build(), output);
    }

    private Optional<QueryFailureInfo> createQueryFailureInfo(ExecutionFailureInfo failureInfo, Optional<StageInfo> outputStage) {
        if (failureInfo == null) {
            return Optional.empty();
        }
        Optional<String> failedTask = outputStage.flatMap(QueryMonitor::findFailedTask);
        return Optional.of(new QueryFailureInfo(failureInfo.getErrorCode(), Optional.ofNullable(failureInfo.getType()), Optional.ofNullable(failureInfo.getMessage()), failedTask.map(task -> task.getTaskStatus().getTaskId().toString()), failedTask.map(task -> task.getTaskStatus().getSelf().getHost()), this.executionFailureInfoCodec.toJson((Object)failureInfo)));
    }

    private static Optional<TaskInfo> findFailedTask(StageInfo stageInfo) {
        for (StageInfo subStage : stageInfo.getSubStages()) {
            Optional<TaskInfo> task = QueryMonitor.findFailedTask(subStage);
            if (!task.isPresent()) continue;
            return task;
        }
        return stageInfo.getTasks().stream().filter(taskInfo -> taskInfo.getTaskStatus().getState() == TaskState.FAILED).findFirst();
    }

    private static Map<String, String> mergeSessionAndCatalogProperties(SessionRepresentation session) {
        LinkedHashMap<String, String> mergedProperties = new LinkedHashMap<String, String>(session.getSystemProperties());
        for (Map.Entry<String, Map<String, String>> entry : session.getUnprocessedCatalogProperties().entrySet()) {
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                mergedProperties.put(entry.getKey() + "." + entry2.getKey(), entry2.getValue());
            }
        }
        for (Map.Entry<String, Map<String, String>> entry : session.getCatalogProperties().entrySet()) {
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                mergedProperties.put(((ConnectorId)entry.getKey()).getCatalogName() + "." + entry2.getKey(), entry2.getValue());
            }
        }
        return ImmutableMap.copyOf(mergedProperties);
    }

    private static void logQueryTimeline(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            DateTime queryStartTime = queryStats.getCreateTime();
            DateTime queryEndTime = queryStats.getEndTime();
            if (queryStartTime == null || queryEndTime == null) {
                return;
            }
            long planning = queryStats.getTotalPlanningTime().toMillis();
            List<StageInfo> stages = StageInfo.getAllStages(queryInfo.getOutputStage());
            long firstTaskStartTime = queryEndTime.getMillis();
            long lastTaskStartTime = queryStartTime.getMillis() + planning;
            long lastTaskEndTime = queryStartTime.getMillis() + planning;
            for (StageInfo stage : stages) {
                if (!stage.getSubStages().isEmpty()) continue;
                for (TaskInfo taskInfo : stage.getTasks()) {
                    DateTime endTime;
                    DateTime lastStartTime;
                    TaskStats taskStats = taskInfo.getStats();
                    DateTime firstStartTime = taskStats.getFirstStartTime();
                    if (firstStartTime != null) {
                        firstTaskStartTime = Math.min(firstStartTime.getMillis(), firstTaskStartTime);
                    }
                    if ((lastStartTime = taskStats.getLastStartTime()) != null) {
                        lastTaskStartTime = Math.max(lastStartTime.getMillis(), lastTaskStartTime);
                    }
                    if ((endTime = taskStats.getEndTime()) == null) continue;
                    lastTaskEndTime = Math.max(endTime.getMillis(), lastTaskEndTime);
                }
            }
            long elapsed = Math.max(queryEndTime.getMillis() - queryStartTime.getMillis(), 0L);
            long scheduling = Math.max(firstTaskStartTime - queryStartTime.getMillis() - planning, 0L);
            long running = Math.max(lastTaskEndTime - firstTaskStartTime, 0L);
            long finishing = Math.max(queryEndTime.getMillis() - lastTaskEndTime, 0L);
            QueryMonitor.logQueryTimeline(queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(""), elapsed, planning, scheduling, running, finishing, queryStartTime, queryEndTime);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error logging query timeline");
        }
    }

    private static void logQueryTimeline(BasicQueryInfo queryInfo) {
        DateTime queryStartTime = queryInfo.getQueryStats().getCreateTime();
        DateTime queryEndTime = queryInfo.getQueryStats().getEndTime();
        if (queryStartTime == null || queryEndTime == null) {
            return;
        }
        long elapsed = Math.max(queryEndTime.getMillis() - queryStartTime.getMillis(), 0L);
        QueryMonitor.logQueryTimeline(queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(""), elapsed, elapsed, 0L, 0L, 0L, queryStartTime, queryEndTime);
    }

    private static void logQueryTimeline(QueryId queryId, String transactionId, long elapsedMillis, long planningMillis, long schedulingMillis, long runningMillis, long finishingMillis, DateTime queryStartTime, DateTime queryEndTime) {
        log.info("TIMELINE: Query %s :: Transaction:[%s] :: elapsed %sms :: planning %sms :: scheduling %sms :: running %sms :: finishing %sms :: begin %s :: end %s", new Object[]{queryId, transactionId, elapsedMillis, planningMillis, schedulingMillis, runningMillis, finishingMillis, queryStartTime, queryEndTime});
    }

    private static List<StageCpuDistribution> getCpuDistributions(QueryInfo queryInfo) {
        if (!queryInfo.getOutputStage().isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        QueryMonitor.populateDistribution(queryInfo.getOutputStage().get(), (ImmutableList.Builder<StageCpuDistribution>)builder);
        return builder.build();
    }

    private static void populateDistribution(StageInfo stageInfo, ImmutableList.Builder<StageCpuDistribution> distributions) {
        distributions.add((Object)QueryMonitor.computeCpuDistribution(stageInfo));
        for (StageInfo subStage : stageInfo.getSubStages()) {
            QueryMonitor.populateDistribution(subStage, distributions);
        }
    }

    private static StageCpuDistribution computeCpuDistribution(StageInfo stageInfo) {
        Distribution cpuDistribution = new Distribution();
        for (TaskInfo taskInfo : stageInfo.getTasks()) {
            cpuDistribution.add(taskInfo.getStats().getTotalCpuTime().toMillis());
        }
        Distribution.DistributionSnapshot snapshot = cpuDistribution.snapshot();
        return new StageCpuDistribution(stageInfo.getStageId().getId(), stageInfo.getTasks().size(), snapshot.getP25(), snapshot.getP50(), snapshot.getP75(), snapshot.getP90(), snapshot.getP95(), snapshot.getP99(), snapshot.getMin(), snapshot.getMax(), (long)snapshot.getTotal(), snapshot.getTotal() / snapshot.getCount());
    }

    public static class JsonPlanFragment {
        @JsonRawValue
        private final String plan;

        @JsonCreator
        public JsonPlanFragment(String plan) {
            this.plan = plan;
        }

        @JsonProperty
        public String getPlan() {
            return this.plan;
        }
    }
}

