/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;

public class ValuesStatsRule
implements ComposableStatsCalculator.Rule<ValuesNode> {
    private static final Pattern<ValuesNode> PATTERN = Patterns.values();
    private final Metadata metadata;

    public ValuesStatsRule(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<ValuesNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(ValuesNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate.Builder statsBuilder = PlanNodeStatsEstimate.builder();
        statsBuilder.setOutputRowCount(node.getRows().size());
        for (int variableId = 0; variableId < node.getOutputVariables().size(); ++variableId) {
            VariableReferenceExpression variable = (VariableReferenceExpression)node.getOutputVariables().get(variableId);
            List<Object> symbolValues = this.getVariableValues(node, variableId, session, variable.getType());
            statsBuilder.addVariableStatistics(variable, this.buildVariableStatistics(symbolValues, session, variable.getType()));
        }
        return Optional.of(statsBuilder.build());
    }

    private List<Object> getVariableValues(ValuesNode valuesNode, int symbolId, Session session, Type type) {
        if (UnknownType.UNKNOWN.equals(type)) {
            return IntStream.range(0, valuesNode.getRows().size()).mapToObj(rowId -> null).collect(Collectors.toList());
        }
        return valuesNode.getRows().stream().map(row -> (RowExpression)row.get(symbolId)).map(rowExpression -> {
            if (OriginalExpressionUtils.isExpression(rowExpression)) {
                return ExpressionInterpreter.evaluateConstantExpression(OriginalExpressionUtils.castToExpression(rowExpression), type, this.metadata, session, (List<Expression>)ImmutableList.of());
            }
            return RowExpressionInterpreter.evaluateConstantRowExpression(rowExpression, this.metadata, session.toConnectorSession());
        }).collect(Collectors.toList());
    }

    private VariableStatsEstimate buildVariableStatistics(List<Object> values, Session session, Type type) {
        List nonNullValues = (List)values.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (nonNullValues.isEmpty()) {
            return VariableStatsEstimate.zero();
        }
        double[] valuesAsDoubles = nonNullValues.stream().map(value -> StatsUtil.toStatsRepresentation(this.metadata, session, type, value)).filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble).toArray();
        double lowValue = DoubleStream.of(valuesAsDoubles).min().orElse(Double.NEGATIVE_INFINITY);
        double highValue = DoubleStream.of(valuesAsDoubles).max().orElse(Double.POSITIVE_INFINITY);
        double valuesCount = values.size();
        double nonNullValuesCount = nonNullValues.size();
        long distinctValuesCount = nonNullValues.stream().distinct().count();
        return VariableStatsEstimate.builder().setNullsFraction((valuesCount - nonNullValuesCount) / valuesCount).setLowValue(lowValue).setHighValue(highValue).setDistinctValuesCount(distinctValuesCount).build();
    }
}

